/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.core.cast.NameToJavaStringNodeGen;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.utils.Utils;

@GenerateUncached
@GenerateCached(value=false)
@GenerateInline
public abstract class NameToJavaStringNode
extends RubyBaseNode {
    public abstract String execute(Node var1, Object var2);

    public static String executeUncached(Object name) {
        return NameToJavaStringNodeGen.getUncached().execute(null, name);
    }

    @Specialization(guards={"libString.isRubyString(this, value)"}, limit="1")
    static String stringNameToJavaString(Node node, Object value, @Cached @Cached.Exclusive RubyStringLibrary libString, @Cached @Cached.Shared ToJavaStringNode toJavaStringNode) {
        return toJavaStringNode.execute(node, value);
    }

    @Specialization
    static String symbolNameToJavaString(Node node, RubySymbol value, @Cached @Cached.Shared ToJavaStringNode toJavaStringNode) {
        return toJavaStringNode.execute(node, value);
    }

    @Specialization
    static String nameToJavaString(String value) {
        return value;
    }

    @Specialization(guards={"!isString(object)", "!isRubySymbol(object)", "isNotRubyString(object)"})
    static String nameToJavaString(Node node, Object object, @Cached InlinedBranchProfile errorProfile, @Cached(inline=false) DispatchNode toStr, @Cached @Cached.Exclusive RubyStringLibrary libString, @Cached @Cached.Exclusive ToJavaStringNode toJavaStringNode) {
        Object coerced;
        try {
            coerced = toStr.call(object, "to_str");
        }
        catch (RaiseException e) {
            errorProfile.enter(node);
            if (e.getException().getLogicalClass() == NameToJavaStringNode.coreLibrary((Node)node).noMethodErrorClass) {
                throw new RaiseException(NameToJavaStringNode.getContext(node), NameToJavaStringNode.coreExceptions(node).typeError(Utils.concat(object, (Object)" is not a symbol nor a string"), node));
            }
            throw e;
        }
        if (libString.isRubyString(node, coerced)) {
            return toJavaStringNode.execute(node, coerced);
        }
        errorProfile.enter(node);
        throw new RaiseException(NameToJavaStringNode.getContext(node), NameToJavaStringNode.coreExceptions(node).typeErrorBadCoercion(object, "String", "to_str", coerced, node));
    }
}

