/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.core.cast.HashCastNodeGen;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyContextSourceNodeCustomExecuteVoid;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;

@GenerateCached(value=false)
@GenerateInline
public abstract class HashCastNode
extends RubyBaseNode {
    public abstract RubyHash execute(Node var1, Object var2);

    @Specialization
    static RubyHash castHash(RubyHash hash) {
        return hash;
    }

    @Specialization(guards={"!isRubyHash(object)"})
    static RubyHash cast(Node node, Object object, @Cached InlinedBranchProfile errorProfile, @Cached(inline=false) DispatchNode toHashNode) {
        Object result = toHashNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, object, "to_hash");
        if (result == DispatchNode.MISSING) {
            errorProfile.enter(node);
            throw new RaiseException(HashCastNode.getContext(node), HashCastNode.coreExceptions(node).typeErrorNoImplicitConversion(object, "Hash", node));
        }
        if (!RubyGuards.isRubyHash(result)) {
            errorProfile.enter(node);
            throw new RaiseException(HashCastNode.getContext(node), HashCastNode.coreExceptions(node).typeErrorCantConvertTo(object, "Hash", "to_hash", result, node));
        }
        return (RubyHash)result;
    }

    @NodeChild(value="childNode", type=RubyNode.class)
    public static abstract class HashCastASTNode
    extends RubyContextSourceNodeCustomExecuteVoid {
        protected abstract RubyNode getChildNode();

        @Specialization
        RubyHash cast(Object object, @Cached HashCastNode hashCastNode) {
            return hashCastNode.execute(this, object);
        }

        @Override
        public final Nil executeVoid(VirtualFrame frame) {
            return this.getChildNode().executeVoid(frame);
        }

        @Override
        public RubyNode cloneUninitialized() {
            HashCastASTNode copy = HashCastNodeGen.HashCastASTNodeGen.create(this.getChildNode().cloneUninitialized());
            return copy.copyFlags(this);
        }
    }
}

