/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.concurrent.TimeUnit;
import org.truffleruby.core.cast.ToLongNode;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;

@GenerateInline
@GenerateCached(value=false)
public abstract class DurationToNanoSecondsNode
extends RubyBaseNode {
    public abstract long execute(Node var1, Object var2);

    @Specialization
    static long noDuration(NotProvided duration) {
        return Long.MAX_VALUE;
    }

    @Specialization
    static long duration(Node node, long duration, @Cached @Cached.Exclusive InlinedConditionProfile durationLessThanZeroProfile) {
        return DurationToNanoSecondsNode.validate(node, TimeUnit.SECONDS.toNanos(duration), durationLessThanZeroProfile);
    }

    @Specialization
    static long duration(Node node, double duration, @Cached @Cached.Exclusive InlinedConditionProfile durationLessThanZeroProfile) {
        return DurationToNanoSecondsNode.validate(node, (long)(duration * 1.0E9), durationLessThanZeroProfile);
    }

    @Fallback
    static long duration(Node node, Object duration, @Cached(inline=false) DispatchNode durationToNanoSeconds, @Cached @Cached.Exclusive InlinedConditionProfile durationLessThanZeroProfile, @Cached ToLongNode toLongNode) {
        Object nanoseconds = durationToNanoSeconds.call((Object)DurationToNanoSecondsNode.coreLibrary((Node)node).truffleKernelOperationsModule, "convert_duration_to_nanoseconds", duration);
        return DurationToNanoSecondsNode.validate(node, toLongNode.execute(node, nanoseconds), durationLessThanZeroProfile);
    }

    private static long validate(Node node, long durationInNanos, InlinedConditionProfile durationLessThanZeroProfile) {
        if (durationLessThanZeroProfile.profile(node, durationInNanos < 0L)) {
            throw new RaiseException(DurationToNanoSecondsNode.getContext(node), DurationToNanoSecondsNode.coreExceptions(node).argumentErrorTimeIntervalPositive(node));
        }
        return durationInNanos;
    }
}

