/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.objects.LogicalClassNode;

@GenerateInline
@GenerateCached(value=false)
public abstract class CmpIntNode
extends RubyBaseNode {
    public abstract int executeCmpInt(Node var1, Object var2, Object var3, Object var4);

    @Specialization
    static int cmpInt(int value, Object receiver, Object other) {
        return value;
    }

    @Specialization
    static int cmpLong(long value, Object receiver, Object other) {
        if (value > 0L) {
            return 1;
        }
        if (value < 0L) {
            return -1;
        }
        return 0;
    }

    @Specialization
    static int cmpBignum(RubyBignum value, Object receiver, Object other) {
        return value.value.signum();
    }

    @Specialization
    static int cmpNil(Node node, Nil nil, Object receiver, Object other) {
        throw new RaiseException(CmpIntNode.getContext(node), CmpIntNode.coreExceptions(node).argumentError(CmpIntNode.formatMessage(receiver, other), node));
    }

    @CompilerDirectives.TruffleBoundary
    private static String formatMessage(Object receiver, Object other) {
        return StringUtils.format("comparison of %s with %s failed", LogicalClassNode.getUncached().execute((Object)receiver).fields.getName(), LogicalClassNode.getUncached().execute((Object)other).fields.getName());
    }

    @Specialization(guards={"!isRubyInteger(value)", "!isNil(value)"})
    static int cmpObject(Node node, Object value, Object receiver, Object other, @Cached(inline=false) DispatchNode gtNode, @Cached(inline=false) DispatchNode ltNode, @Cached BooleanCastNode gtCastNode, @Cached BooleanCastNode ltCastNode) {
        if (gtCastNode.execute(node, gtNode.call(value, ">", 0))) {
            return 1;
        }
        if (ltCastNode.execute(node, ltNode.call(value, "<", 0))) {
            return -1;
        }
        return 0;
    }
}

