/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array.library;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import java.util.Set;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.array.library.DoubleArrayStore;
import org.truffleruby.core.array.library.IntegerArrayStore;
import org.truffleruby.core.array.library.LongArrayStore;
import org.truffleruby.core.array.library.ObjectArrayStore;
import org.truffleruby.core.array.library.ZeroLengthArrayStore;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ObjectGraphNode;
import org.truffleruby.language.objects.shared.SharedObjects;
import org.truffleruby.language.objects.shared.WriteBarrierNode;

@ExportLibrary(value=ArrayStoreLibrary.class)
@GenerateUncached
@ImportStatic(value={ArrayGuards.class})
public final class SharedArrayStorage
implements ObjectGraphNode {
    public final Object storage;
    static final ArrayStoreLibrary.ArrayAllocator SHARED_ZERO_LENGTH_ARRAY_ALLOCATOR = new SharedArrayAllocator(ZeroLengthArrayStore.ZERO_LENGTH_ALLOCATOR);
    static final ArrayStoreLibrary.ArrayAllocator SHARED_INTEGER_ARRAY_ALLOCATOR = new SharedArrayAllocator(IntegerArrayStore.INTEGER_ARRAY_ALLOCATOR);
    static final ArrayStoreLibrary.ArrayAllocator SHARED_LONG_ARRAY_ALLOCATOR = new SharedArrayAllocator(LongArrayStore.LONG_ARRAY_ALLOCATOR);
    static final ArrayStoreLibrary.ArrayAllocator SHARED_DOUBLE_ARRAY_ALLOCATOR = new SharedArrayAllocator(DoubleArrayStore.DOUBLE_ARRAY_ALLOCATOR);
    static final ArrayStoreLibrary.ArrayAllocator SHARED_OBJECT_ARRAY_ALLOCATOR = new SharedArrayAllocator(ObjectArrayStore.OBJECT_ARRAY_ALLOCATOR);

    public SharedArrayStorage(Object storage) {
        assert (!(storage instanceof SharedArrayStorage));
        this.storage = storage;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean allElementsShared(int size) {
        if (this.storage == null || this.storage instanceof ZeroLengthArrayStore) {
            return true;
        }
        ArrayStoreLibrary stores = ArrayStoreLibrary.getUncached(this.storage);
        Iterable<Object> elements = stores.getIterable(this.storage, 0, size);
        for (Object e : elements) {
            if (e == null || !(e instanceof RubyDynamicObject) || SharedObjects.isShared(e)) continue;
            assert (false) : String.format("Unshared element %s.%n", e);
            return false;
        }
        return true;
    }

    @ExportMessage
    protected Object read(int index, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.read(this.storage, index);
    }

    @ExportMessage
    protected void write(int index, Object value, @Cached @Cached.Shared WriteBarrierNode writeBarrierNode, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores, @Bind(value="$node") Node node) {
        writeBarrierNode.execute(node, value);
        stores.write(this.storage, index, value);
    }

    @ExportMessage
    protected void fill(int start, int length, Object value, @Cached @Cached.Shared WriteBarrierNode writeBarrierNode, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores, @Bind(value="$node") Node node) {
        writeBarrierNode.execute(node, value);
        stores.fill(this.storage, start, length, value);
    }

    @ExportMessage
    protected boolean acceptsValue(Object value, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.acceptsValue(this.storage, value);
    }

    @ExportMessage
    protected boolean acceptsAllValues(Object otherStore, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.acceptsAllValues(this.storage, otherStore);
    }

    @ExportMessage
    protected boolean isMutable(@CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.isMutable(this.storage);
    }

    @ExportMessage
    protected boolean isNative(@CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.isNative(this.storage);
    }

    @ExportMessage
    protected boolean isPrimitive(@CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.isPrimitive(this.storage);
    }

    @ExportMessage
    public boolean isShared() {
        return true;
    }

    @ExportMessage
    public Object initialStore() {
        return ArrayStoreLibrary.initialStorage(true);
    }

    @ExportMessage
    public Object backingStore(@CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.backingStore(this.storage);
    }

    @ExportMessage
    public Object makeShared(int size) {
        return this;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    protected String toString(@CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return String.format("Shared storage of (%s)", stores.toString(this.storage));
    }

    @ExportMessage
    protected int capacity(@CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.capacity(this.storage);
    }

    @ExportMessage
    protected Object expand(int capacity, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return new SharedArrayStorage(stores.expand(this.storage, capacity));
    }

    @ExportMessage
    protected Object extractRange(int start, int end, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return new SharedArrayStorage(stores.extractRange(this.storage, start, end));
    }

    @ExportMessage
    protected Object extractRangeAndUnshare(int start, int end, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.extractRange(this.storage, start, end);
    }

    @ExportMessage
    protected Object[] boxedCopyOfRange(int start, int length, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.boxedCopyOfRange(this.storage, start, length);
    }

    @ExportMessage
    protected void clear(int start, int length, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        stores.clear(this.storage, start, length);
    }

    @ExportMessage
    protected Object toJavaArrayCopy(int length, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.toJavaArrayCopy(this.storage, length);
    }

    @ExportMessage
    protected void sort(int size, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        stores.sort(this.storage, size);
    }

    @ExportMessage
    protected Iterable<Object> getIterable(int from, int length, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.getIterable(this.storage, from, length);
    }

    @ExportMessage
    protected ArrayStoreLibrary.ArrayAllocator generalizeForValue(Object newValue, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.generalizeForValue(this.storage, newValue);
    }

    @ExportMessage
    protected ArrayStoreLibrary.ArrayAllocator generalizeForStore(Object newStore, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.generalizeForStore(this.storage, newStore);
    }

    @ExportMessage
    public ArrayStoreLibrary.ArrayAllocator generalizeForSharing(@CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.generalizeForSharing(this.storage);
    }

    @ExportMessage
    protected Object allocateForNewValue(Object newValue, int length, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return new SharedArrayStorage(stores.allocateForNewValue(this.storage, newValue, length));
    }

    @ExportMessage
    protected Object allocateForNewStore(Object newStore, int length, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return new SharedArrayStorage(stores.allocateForNewStore(this.storage, newStore, length));
    }

    @ExportMessage
    protected Object unsharedAllocateForNewStore(Object newStore, int length, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.allocateForNewStore(this.storage, newStore, length);
    }

    @ExportMessage
    protected boolean isDefaultValue(Object value, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.isDefaultValue(this.storage, value);
    }

    @ExportMessage
    protected ArrayStoreLibrary.ArrayAllocator allocator(@CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return new SharedArrayAllocator(stores.unsharedAllocator(this.storage));
    }

    @ExportMessage
    protected ArrayStoreLibrary.ArrayAllocator unsharedAllocator(@CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.unsharedAllocator(this.storage);
    }

    public boolean hasObjectArrayStorage() {
        return this.storage.getClass() == Object[].class;
    }

    @Override
    public void getAdjacentObjects(Set<Object> reachable) {
        if (this.hasObjectArrayStorage()) {
            Object[] objectArray = (Object[])this.storage;
            for (int i = 0; i < objectArray.length; ++i) {
                Object value = objectArray[i];
                if (!ObjectGraph.isRubyObject(value)) continue;
                reachable.add(value);
            }
        } else if (this.storage instanceof ObjectGraphNode) {
            ((ObjectGraphNode)this.storage).getAdjacentObjects(reachable);
        }
    }

    private static final class SharedArrayAllocator
    extends ArrayStoreLibrary.ArrayAllocator {
        private final ArrayStoreLibrary.ArrayAllocator storageAllocator;

        SharedArrayAllocator(ArrayStoreLibrary.ArrayAllocator storageAllocator) {
            this.storageAllocator = storageAllocator;
        }

        @Override
        public SharedArrayStorage allocate(int capacity) {
            return new SharedArrayStorage(this.storageAllocator.allocate(capacity));
        }

        @Override
        public boolean accepts(Object value) {
            return this.storageAllocator.accepts(value);
        }

        @Override
        public boolean specializesFor(Object value) {
            return this.storageAllocator.specializesFor(value);
        }

        @Override
        public boolean isDefaultValue(Object value) {
            return this.storageAllocator.isDefaultValue(value);
        }
    }

    @ExportMessage
    @ImportStatic(value={ArrayGuards.class})
    static final class CopyContents {
        CopyContents() {
        }

        @Specialization(guards={"srcStore == destStore"})
        static void copyContents(SharedArrayStorage srcStore, int srcStart, SharedArrayStorage destStore, int destStart, int length) {
            System.arraycopy(srcStore.storage, srcStart, destStore.storage, destStart, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"differentStores(srcStore, destStore)"}, limit="storageStrategyLimit()")
        static void copyContents(SharedArrayStorage srcStore, int srcStart, Object destStore, int destStart, int length, @Cached @Cached.Exclusive LoopConditionProfile loopProfile, @CachedLibrary(value="srcStore.storage") ArrayStoreLibrary srcStores, @CachedLibrary(value="destStore") ArrayStoreLibrary destStores) {
            int i = 0;
            try {
                while (loopProfile.inject(i < length)) {
                    destStores.write(destStore, destStart + i, srcStore.read(srcStart + i, srcStores));
                    TruffleSafepoint.poll((Node)destStores);
                    ++i;
                }
            }
            finally {
                RubyBaseNode.profileAndReportLoopCount(destStores.getNode(), loopProfile, i);
            }
        }

        protected static boolean differentStores(SharedArrayStorage srcStore, Object destStore) {
            return srcStore != destStore;
        }
    }
}

