/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.language.RubyBaseNode;

@ImportStatic(value={ArrayGuards.class})
public abstract class ArrayPopOneNode
extends RubyBaseNode {
    public abstract Object executePopOne(RubyArray var1);

    @Specialization(guards={"isEmptyArray(array)"})
    Object popOneEmpty(RubyArray array) {
        return nil;
    }

    @Specialization(guards={"!isEmptyArray(array)"}, limit="storageStrategyLimit()")
    Object popOne(RubyArray array, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
        int size = array.size;
        Object value = stores.read(store, size - 1);
        stores.clear(store, size - 1, 1);
        ArrayHelpers.setSize(array, size - 1);
        return value;
    }
}

