/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayBuilderNode;
import org.truffleruby.core.array.ArrayOperations;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.array.library.SharedArrayStorage;

public abstract class ArrayHelpers {
    public static void setStoreAndSize(RubyArray array, Object store, int size) {
        assert (store instanceof SharedArrayStorage == array.getShape().isShared());
        array.setStore(store);
        ArrayHelpers.setSize(array, size);
    }

    public static void setSize(RubyArray array, int size) {
        assert (ArrayOperations.getStoreCapacity(array) >= size);
        array.size = size;
    }

    private static boolean assertValidElements(Object store, int size) {
        return !(store instanceof Object[]) || ArrayUtils.assertValidElements((Object[])store, 0, size);
    }

    public static RubyArray createArray(RubyContext context, RubyLanguage language, Object store, int size) {
        assert (!(store instanceof Object[]) || store.getClass() == Object[].class);
        assert (!(store instanceof SharedArrayStorage));
        assert (ArrayHelpers.assertValidElements(store, size));
        return new RubyArray(context.getCoreLibrary().arrayClass, language.arrayShape, store, size);
    }

    public static RubyArray createArray(RubyContext context, RubyLanguage language, int[] store) {
        return ArrayHelpers.createArray(context, language, store, store.length);
    }

    public static RubyArray createArray(RubyContext context, RubyLanguage language, long[] store) {
        return ArrayHelpers.createArray(context, language, store, store.length);
    }

    public static RubyArray createArray(RubyContext context, RubyLanguage language, Object[] store) {
        assert (store.getClass() == Object[].class);
        return ArrayHelpers.createArray(context, language, store, store.length);
    }

    public static RubyArray createEmptyArray(RubyContext context, RubyLanguage language) {
        return new RubyArray(context.getCoreLibrary().arrayClass, language.arrayShape, ArrayStoreLibrary.initialStorage(false), 0);
    }

    public static Object specializedJavaArrayOf(ArrayBuilderNode builder, Object object) {
        ArrayBuilderNode.BuilderState state = builder.start(1);
        builder.appendValue(state, 0, object);
        return builder.finish(state, 1);
    }

    public static Object specializedJavaArrayOf(ArrayBuilderNode builder, Object ... objects) {
        ArrayBuilderNode.BuilderState state = builder.start(objects.length);
        for (Object object : objects) {
            builder.appendValue(state, 0, object);
        }
        return builder.finish(state, objects.length);
    }

    public static RubyArray specializedRubyArrayOf(RubyContext context, RubyLanguage language, ArrayBuilderNode builder, Object object) {
        return ArrayHelpers.createArray(context, language, ArrayHelpers.specializedJavaArrayOf(builder, object), 1);
    }

    public static RubyArray specializedRubyArrayOf(RubyContext context, RubyLanguage language, ArrayBuilderNode builder, Object ... objects) {
        return ArrayHelpers.createArray(context, language, ArrayHelpers.specializedJavaArrayOf(builder, objects), objects.length);
    }
}

