/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.core.array.ArrayDeconstructNodeGen;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;

@NodeChild(value="valueNode", type=RubyNode.class)
public abstract class ArrayDeconstructNode
extends RubyContextSourceNode {
    abstract RubyNode getValueNode();

    @Specialization
    Object deconstruct(VirtualFrame frame, Object toMatch, @Cached DispatchNode respondToNode, @Cached BooleanCastNode booleanCastNode, @Cached DispatchNode deconstructNode, @Cached InlinedConditionProfile hasDeconstructProfile, @Cached InlinedBranchProfile errorProfile) {
        if (hasDeconstructProfile.profile((Node)this, booleanCastNode.execute(this, respondToNode.callWithFrame(DispatchConfiguration.PUBLIC, (Frame)frame, toMatch, "respond_to?", this.coreSymbols().DECONSTRUCT)))) {
            Object deconstructed = deconstructNode.callWithFrame(DispatchConfiguration.PUBLIC, (Frame)frame, toMatch, "deconstruct");
            if (deconstructed instanceof RubyArray) {
                return deconstructed;
            }
            errorProfile.enter((Node)this);
            throw new RaiseException(this.getContext(), this.coreExceptions().typeError("deconstruct must return Array", this));
        }
        return nil;
    }

    @Override
    public RubyNode cloneUninitialized() {
        return ArrayDeconstructNodeGen.create(this.getValueNode().cloneUninitialized()).copyFlags(this);
    }
}

