/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.truffleruby.core.array.ArrayBuilderNodeFactory;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.language.RubyBaseNode;

public abstract class ArrayBuilderNode
extends RubyBaseNode {
    @NeverDefault
    public static ArrayBuilderNode create() {
        return new ArrayBuilderProxyNode();
    }

    public abstract BuilderState start(int var1);

    public abstract void appendArray(BuilderState var1, int var2, RubyArray var3);

    public abstract void appendValue(BuilderState var1, int var2, Object var3);

    public abstract Object finish(BuilderState var1, int var2);

    private static final class ArrayBuilderProxyNode
    extends ArrayBuilderNode {
        @Node.Child
        StartNode startNode = new StartNode(ArrayStoreLibrary.initialAllocator(false));
        @Node.Child
        AppendArrayNode appendArrayNode;
        @Node.Child
        AppendOneNode appendOneNode;

        private ArrayBuilderProxyNode() {
        }

        @Override
        public BuilderState start(int length) {
            return this.startNode.start(length);
        }

        @Override
        public void appendArray(BuilderState state, int index, RubyArray array) {
            this.getAppendArrayNode().executeAppend(state, index, array);
        }

        @Override
        public void appendValue(BuilderState state, int index, Object value) {
            this.getAppendOneNode().executeAppend(state, index, value);
        }

        @Override
        public Object finish(BuilderState state, int length) {
            assert (length == state.nextIndex);
            return state.store;
        }

        private AppendArrayNode getAppendArrayNode() {
            if (this.appendArrayNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.appendArrayNode = (AppendArrayNode)this.insert(AppendArrayNode.create());
            }
            return this.appendArrayNode;
        }

        private AppendOneNode getAppendOneNode() {
            if (this.appendOneNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.appendOneNode = (AppendOneNode)this.insert(AppendOneNode.create());
            }
            return this.appendOneNode;
        }

        public synchronized ArrayStoreLibrary.ArrayAllocator updateStrategy(ArrayStoreLibrary.ArrayAllocator newStrategy) {
            ArrayStoreLibrary.ArrayAllocator oldStrategy = this.startNode.allocator;
            ArrayStoreLibrary.ArrayAllocator updatedAllocator = oldStrategy != newStrategy ? ArrayStoreLibrary.getUncached().generalizeForStore(oldStrategy.allocate(0), newStrategy.allocate(0)) : oldStrategy;
            if (updatedAllocator != oldStrategy) {
                this.startNode.replace(new StartNode(updatedAllocator));
            }
            if (newStrategy != oldStrategy) {
                if (this.appendArrayNode != null) {
                    this.appendArrayNode.replace(AppendArrayNode.create());
                }
                if (this.appendOneNode != null) {
                    this.appendOneNode.replace(AppendOneNode.create());
                }
            }
            return updatedAllocator;
        }
    }

    @ImportStatic(value={ArrayGuards.class})
    public static abstract class AppendArrayNode
    extends ArrayBuilderBaseNode {
        public static AppendArrayNode create() {
            return ArrayBuilderNodeFactory.AppendArrayNodeGen.create();
        }

        public abstract void executeAppend(BuilderState var1, int var2, RubyArray var3);

        @Specialization(guards={"arrays.acceptsAllValues(state.store, other.getStore())"}, limit="storageStrategyLimit()")
        void appendCompatibleStrategy(BuilderState state, int index, RubyArray other, @Bind(value="state.store") Object store, @Bind(value="other.getStore()") Object otherStore, @CachedLibrary(value="store") ArrayStoreLibrary arrays, @CachedLibrary(value="otherStore") ArrayStoreLibrary others, @Cached BranchProfile growProfile) {
            assert (state.nextIndex == index);
            int otherSize = other.size;
            int neededSize = index + otherSize;
            int length = arrays.capacity(state.store);
            if (neededSize > length) {
                growProfile.enter();
                int capacity = ArrayUtils.capacity(this.getLanguage(), length, neededSize);
                state.store = arrays.expand(state.store, capacity);
                state.capacity = capacity;
            }
            others.copyContents(otherStore, 0, state.store, index, otherSize);
            state.nextIndex += otherSize;
        }

        @Specialization(guards={"!arrayLibrary.acceptsAllValues(state.store, other.getStore())"}, limit="1")
        void appendNewStrategy(BuilderState state, int index, RubyArray other, @Bind(value="state.store") Object store, @CachedLibrary(value="store") ArrayStoreLibrary arrayLibrary) {
            assert (state.nextIndex == index);
            int otherSize = other.size;
            if (otherSize != 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                ArrayStoreLibrary newArrayLibrary = ArrayStoreLibrary.getUncached();
                int neededSize = index + otherSize;
                int currentCapacity = state.capacity;
                int neededCapacity = neededSize > currentCapacity ? ArrayUtils.capacity(this.getLanguage(), currentCapacity, neededSize) : currentCapacity;
                ArrayStoreLibrary.ArrayAllocator allocator = this.replaceNodes(newArrayLibrary.generalizeForStore(state.store, other.getStore()));
                Object newStore = allocator.allocate(neededCapacity);
                newArrayLibrary.copyContents(state.store, 0, newStore, 0, index);
                Object otherStore = other.getStore();
                newArrayLibrary.copyContents(otherStore, 0, newStore, index, otherSize);
                state.store = newStore;
                state.capacity = neededCapacity;
                state.nextIndex += otherSize;
            }
        }
    }

    @ImportStatic(value={ArrayGuards.class})
    public static abstract class AppendOneNode
    extends ArrayBuilderBaseNode {
        public static AppendOneNode create() {
            return ArrayBuilderNodeFactory.AppendOneNodeGen.create();
        }

        public abstract void executeAppend(BuilderState var1, int var2, Object var3);

        @Specialization(guards={"arrays.acceptsValue(state.store, value)"}, limit="1")
        void appendCompatibleType(BuilderState state, int index, Object value, @Bind(value="state.store") Object store, @CachedLibrary(value="store") ArrayStoreLibrary arrays, @Cached BranchProfile growProfile) {
            assert (state.nextIndex == index);
            int length = arrays.capacity(state.store);
            if (index >= length) {
                growProfile.enter();
                int capacity = ArrayUtils.capacityForOneMore(this.getLanguage(), length);
                state.store = arrays.expand(state.store, capacity);
                state.capacity = capacity;
            }
            arrays.write(state.store, index, value);
            ++state.nextIndex;
        }

        @Specialization(guards={"!arrays.acceptsValue(state.store, value)"}, limit="1")
        void appendNewStrategy(BuilderState state, int index, Object value, @Bind(value="state.store") Object store, @CachedLibrary(value="store") ArrayStoreLibrary arrays) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            assert (state.nextIndex == index);
            ArrayStoreLibrary stores = ArrayStoreLibrary.getUncached();
            ArrayStoreLibrary.ArrayAllocator newAllocator = stores.generalizeForValue(state.store, value);
            int currentCapacity = state.capacity;
            int neededCapacity = index >= currentCapacity ? ArrayUtils.capacityForOneMore(this.getLanguage(), currentCapacity) : currentCapacity;
            newAllocator = this.replaceNodes(newAllocator);
            Object newStore = newAllocator.allocate(neededCapacity);
            stores.copyContents(state.store, 0, newStore, 0, index);
            stores.write(newStore, index, value);
            state.store = newStore;
            state.capacity = neededCapacity;
            ++state.nextIndex;
        }
    }

    public static final class StartNode
    extends ArrayBuilderBaseNode {
        private final ArrayStoreLibrary.ArrayAllocator allocator;

        public StartNode(ArrayStoreLibrary.ArrayAllocator allocator) {
            this.allocator = allocator;
        }

        public BuilderState start(int length) {
            if (this.allocator == ArrayStoreLibrary.initialAllocator(false)) {
                return new BuilderState(this.allocator.allocate(0), length);
            }
            return new BuilderState(this.allocator.allocate(length), length);
        }
    }

    public static abstract class ArrayBuilderBaseNode
    extends RubyBaseNode {
        protected ArrayStoreLibrary.ArrayAllocator replaceNodes(ArrayStoreLibrary.ArrayAllocator strategy) {
            ArrayBuilderProxyNode parent = (ArrayBuilderProxyNode)this.getParent();
            return parent.updateStrategy(strategy);
        }
    }

    public static final class BuilderState {
        private int capacity;
        private int nextIndex = 0;
        Object store;

        private BuilderState(Object store, int capacity) {
            this.capacity = capacity;
            this.store = store;
        }
    }
}

