/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NonIdempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.ArrayList;
import org.truffleruby.cext.ValueWrapper;
import org.truffleruby.core.MarkingService;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.dispatch.DispatchNode;

public abstract class MarkingServiceNodes {

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class RunMarkOnExitNode
    extends RubyBaseNode {
        public abstract void execute(Node var1, MarkingService.ExtensionCallStack var2);

        @Specialization(guards={"!stack.hasMarkObjects()"})
        static void nothingToMark(MarkingService.ExtensionCallStack stack) {
        }

        @Specialization(guards={"stack.hasSingleMarkObject()"})
        static void markSingleObject(Node node, MarkingService.ExtensionCallStack stack, @Cached(inline=false) @Cached.Shared DispatchNode callNode) {
            ValueWrapper value = stack.getSingleMarkObject();
            callNode.call((Object)RunMarkOnExitNode.getContext((Node)node).getCoreLibrary().truffleCExtModule, "run_marker", value.getObject());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"stack.hasMarkObjects()", "!stack.hasSingleMarkObject()"})
        static void marksToRun(Node node, MarkingService.ExtensionCallStack stack, @Cached(inline=false) @Cached.Shared DispatchNode callNode) {
            ArrayList<ValueWrapper> valuesForMarking = stack.getMarkOnExitObjects();
            stack.push(false, nil, nil);
            try {
                for (ValueWrapper value : valuesForMarking) {
                    callNode.call((Object)RunMarkOnExitNode.getContext((Node)node).getCoreLibrary().truffleCExtModule, "run_marker", value.getObject());
                }
            }
            finally {
                stack.pop();
            }
        }
    }

    @GenerateUncached
    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class KeepAliveNode
    extends RubyBaseNode {
        public abstract void execute(Node var1, ValueWrapper var2);

        @Specialization(guards={"!stack.hasKeptObjects()"})
        static void keepFirstObject(Node node, ValueWrapper object, @Bind(value="getStack(node)") MarkingService.ExtensionCallStack stack) {
            stack.current.preservedObject = object;
        }

        @Specialization(guards={"stack.hasSingleKeptObject()"})
        static void keepCreatingList(Node node, ValueWrapper object, @Bind(value="getStack(node)") MarkingService.ExtensionCallStack stack, @Cached InlinedConditionProfile sameObjectProfile) {
            if (sameObjectProfile.profile(node, object != stack.current.preservedObject)) {
                KeepAliveNode.createKeptList(object, stack);
            }
        }

        @Specialization(guards={"stack.isPreservedObjectListInitialized()", "stack.hasKeptObjects()", "!stack.hasSingleKeptObject()"})
        @CompilerDirectives.TruffleBoundary
        static void keepAddingToList(Node node, ValueWrapper object, @Bind(value="getStack(node)") MarkingService.ExtensionCallStack stack) {
            stack.current.preservedObjectList.add(object);
        }

        @CompilerDirectives.TruffleBoundary
        private static void createKeptList(ValueWrapper object, MarkingService.ExtensionCallStack stack) {
            stack.current.preservedObjectList = new ArrayList();
            stack.current.preservedObjectList.add(stack.current.preservedObject);
            stack.current.preservedObjectList.add(object);
        }

        @NonIdempotent
        protected static MarkingService.ExtensionCallStack getStack(Node node) {
            return KeepAliveNode.getLanguage((Node)node).getCurrentThread().getCurrentFiber().extensionCallStack;
        }
    }
}

