/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core;

import com.oracle.truffle.api.CompilerDirectives;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Objects;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.FinalizerReference;
import org.truffleruby.core.MarkingService;
import org.truffleruby.core.ReferenceProcessingService;
import org.truffleruby.language.RubyDynamicObject;

public final class FinalizationService
extends ReferenceProcessingService<FinalizerReference, Object> {
    public FinalizationService(ReferenceQueue<Object> processingQueue) {
        super(processingQueue);
    }

    public FinalizationService(ReferenceProcessingService.ReferenceProcessor referenceProcessor) {
        this(referenceProcessor.processingQueue);
    }

    @CompilerDirectives.TruffleBoundary
    public FinalizerReference addFinalizer(RubyContext context, Object object, Class<?> owner, Runnable action, RubyDynamicObject root) {
        FinalizerReference newRef = new FinalizerReference(object, (ReferenceQueue<? super Object>)this.processingQueue, this);
        newRef.addFinalizer(owner, action, root);
        this.add(newRef);
        context.getReferenceProcessor().processReferenceQueue(this);
        return newRef;
    }

    @CompilerDirectives.TruffleBoundary
    public void addAdditionalFinalizer(RubyContext context, FinalizerReference existingRef, Object object, Class<?> owner, Runnable action, RubyDynamicObject root) {
        Objects.requireNonNull(existingRef);
        assert (Thread.holdsLock(object)) : "caller must synchronize access to the FinalizerReference";
        existingRef.addFinalizer(owner, action, root);
        context.getReferenceProcessor().processReferenceQueue(this);
    }

    public final void drainFinalizationQueue(RubyContext context) {
        context.getReferenceProcessor().drainReferenceQueues();
    }

    @Override
    protected void processReference(RubyContext context, RubyLanguage language, ReferenceProcessingService.PhantomProcessingReference<?, ?> finalizerReference) {
        super.processReference(context, language, finalizerReference);
        this.runCatchingErrors(context, language, this::processReferenceInternal, (FinalizerReference)finalizerReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processReferenceInternal(RubyContext context, RubyLanguage language, FinalizerReference finalizerReference) {
        MarkingService.ExtensionCallStack stack = language.getCurrentFiber().extensionCallStack;
        stack.push(stack.areKeywordsGiven(), stack.getSpecialVariables(), stack.getBlock());
        try {
            while (!context.isFinalizing()) {
                Finalizer finalizer;
                FinalizationService finalizationService = this;
                synchronized (finalizationService) {
                    finalizer = finalizerReference.getFirstFinalizer();
                }
                if (finalizer == null) {
                    break;
                }
                Runnable action = finalizer.getAction();
                action.run();
            }
        }
        finally {
            stack.pop();
        }
    }

    public synchronized void collectRoots(Collection<Object> roots) {
        for (FinalizerReference finalizerReference = (FinalizerReference)this.getFirst(); finalizerReference != null; finalizerReference = (FinalizerReference)finalizerReference.getNext()) {
            finalizerReference.collectRoots(roots);
        }
    }

    public synchronized FinalizerReference removeFinalizers(Object object, FinalizerReference ref, Class<?> owner) {
        if (ref != null) {
            return ref.removeFinalizers(this, owner);
        }
        return null;
    }

    static final class Finalizer {
        private final Class<?> owner;
        private final Runnable action;
        private final RubyDynamicObject root;

        public Finalizer(Class<?> owner, Runnable action, RubyDynamicObject root) {
            this.owner = owner;
            this.action = action;
            this.root = root;
        }

        public Class<?> getOwner() {
            return this.owner;
        }

        public Runnable getAction() {
            return this.action;
        }

        public RubyDynamicObject getRoot() {
            return this.root;
        }
    }
}

