/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.lang.ref.ReferenceQueue;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.DataObjectFinalizerReference;
import org.truffleruby.core.ReferenceProcessingService;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseRootNode;
import org.truffleruby.language.backtrace.InternalRootNode;

public final class DataObjectFinalizationService
extends ReferenceProcessingService<DataObjectFinalizerReference, Object> {
    private final CallTarget callTarget;

    public DataObjectFinalizationService(RubyLanguage language, ReferenceQueue<Object> processingQueue) {
        super(processingQueue);
        this.callTarget = new DataObjectFinalizerRootNode(language).getCallTarget();
    }

    public DataObjectFinalizationService(RubyLanguage language, ReferenceProcessingService.ReferenceProcessor referenceProcessor) {
        this(language, referenceProcessor.processingQueue);
    }

    @CompilerDirectives.TruffleBoundary
    public DataObjectFinalizerReference addFinalizer(RubyContext context, Object object, Object finalizerCFunction, Object dataStruct) {
        DataObjectFinalizerReference newRef = this.createRef(object, finalizerCFunction, dataStruct);
        this.add(newRef);
        context.getReferenceProcessor().processReferenceQueue(this);
        return newRef;
    }

    public DataObjectFinalizerReference createRef(Object object, Object finalizerCFunction, Object dataStruct) {
        return new DataObjectFinalizerReference(object, this.processingQueue, this, finalizerCFunction, dataStruct);
    }

    @Override
    protected void processReference(RubyContext context, RubyLanguage language, ReferenceProcessingService.PhantomProcessingReference<?, ?> finalizerReference) {
        super.processReference(context, language, finalizerReference);
        this.runCatchingErrors(context, language, this::processReferenceInternal, (DataObjectFinalizerReference)finalizerReference);
    }

    @CompilerDirectives.TruffleBoundary
    void processReferenceInternal(RubyContext context, RubyLanguage language, DataObjectFinalizerReference ref) {
        this.callTarget.call(new Object[]{ref});
    }

    public static final class DataObjectFinalizerRootNode
    extends RubyBaseRootNode
    implements InternalRootNode {
        @Node.Child
        private InteropLibrary callNode = (InteropLibrary)InteropLibrary.getFactory().createDispatched(1);

        public DataObjectFinalizerRootNode(RubyLanguage language) {
            super(language, RubyLanguage.EMPTY_FRAME_DESCRIPTOR, null);
        }

        public Object execute(VirtualFrame frame) {
            return this.execute((DataObjectFinalizerReference)frame.getArguments()[0]);
        }

        public Object execute(DataObjectFinalizerReference ref) {
            if (!this.getContext().isFinalizing()) {
                try {
                    this.callNode.invokeMember((Object)this.getContext().getCoreLibrary().truffleCExtModule, "run_data_finalizer", new Object[]{ref.finalizerCFunction, ref.dataStruct});
                }
                catch (InteropException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            return Nil.INSTANCE;
        }
    }
}

