/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.builtins.CoreMethodNodeManager;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.basicobject.RubyBasicObject;
import org.truffleruby.core.binding.RubyBinding;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.klass.ClassNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.ModuleNodes;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.debug.BindingLocalVariablesObject;
import org.truffleruby.debug.GlobalVariablesObject;
import org.truffleruby.debug.TopScopeObject;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.globals.GlobalVariableReader;
import org.truffleruby.language.globals.GlobalVariables;
import org.truffleruby.language.loader.CodeLoader;
import org.truffleruby.language.loader.FileLoader;
import org.truffleruby.language.loader.ResourceLoader;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.objects.ForeignClassNode;
import org.truffleruby.language.objects.SingletonClassNode;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.RubySource;
import org.truffleruby.parser.YARPTranslatorDriver;
import org.truffleruby.shared.BuildInformationImpl;
import org.truffleruby.shared.TruffleRuby;

public final class CoreLibrary {
    public static final SourceSection UNAVAILABLE_SOURCE_SECTION = Source.newBuilder((String)"ruby", (CharSequence)"", (String)"(unavailable)").build().createUnavailableSection();
    private static final String ERRNO_CONFIG_PREFIX = "platform.errno.";
    private final RubyContext context;
    private final RubyLanguage language;
    public static final SourceSection JAVA_CORE_SOURCE_SECTION = CoreLibrary.initCoreSourceSection();
    public final RubyClass argumentErrorClass;
    public final RubyClass arrayClass;
    public final RubyClass basicObjectClass;
    public final RubyClass bindingClass;
    public final RubyClass classClass;
    public final RubyClass complexClass;
    public final RubyClass dirClass;
    public final RubyClass encodingClass;
    public final RubyClass encodingConverterClass;
    public final RubyClass encodingErrorClass;
    public final RubyClass exceptionClass;
    public final RubyClass falseClass;
    public final RubyClass fiberClass;
    public final RubyClass floatClass;
    public final RubyClass floatDomainErrorClass;
    public final RubyClass frozenErrorClass;
    public final RubyClass hashClass;
    public final RubyClass integerClass;
    public final RubyClass indexErrorClass;
    public final RubyClass keyErrorClass;
    public final RubyClass ioErrorClass;
    public final RubyClass loadErrorClass;
    public final RubyClass localJumpErrorClass;
    public final RubyClass matchDataClass;
    public final RubyClass mathDomainErrorClass;
    public final RubyClass moduleClass;
    public final RubyClass nameErrorClass;
    public final RubyClass nilClass;
    public final RubyClass noMemoryErrorClass;
    public final RubyClass noMethodErrorClass;
    public final RubyClass notImplementedErrorClass;
    public final RubyClass numericClass;
    public final RubyClass objectClass;
    public final RubyClass procClass;
    public final RubyModule processModule;
    public final RubyClass rangeClass;
    public final RubyClass rangeErrorClass;
    public final RubyClass rationalClass;
    public final RubyClass regexpClass;
    public final RubyClass regexpErrorClass;
    public final RubyClass graalErrorClass;
    public final RubyClass runtimeErrorClass;
    public final RubyClass refinementClass;
    public final RubyClass signalExceptionClass;
    public final RubyClass systemStackErrorClass;
    public final RubyClass securityErrorClass;
    public final RubyClass standardErrorClass;
    public final RubyClass stopIterationClass;
    public final RubyModule polyglotModule;
    public final RubyClass polyglotInnerContextClass;
    public final RubyClass polyglotForeignObjectClass;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final RubyClass[] polyglotForeignClasses;
    public final RubyClass unsupportedMessageErrorClass;
    public final RubyClass stringClass;
    public final RubyClass symbolClass;
    public final RubyClass syntaxErrorClass;
    public final RubyClass systemCallErrorClass;
    public final RubyClass systemExitClass;
    public final RubyClass threadClass;
    public final RubyClass threadBacktraceLocationClass;
    public final RubyClass trueClass;
    public final RubyClass typeErrorClass;
    public final RubyClass zeroDivisionErrorClass;
    public final RubyModule enumerableModule;
    public final RubyClass enumeratorClass;
    public final RubyClass arithmeticSequenceClass;
    public final RubyModule errnoModule;
    public final RubyModule kernelModule;
    public final RubyModule truffleFFIModule;
    public final RubyClass truffleFFIPointerClass;
    public final RubyClass truffleFFINullPointerErrorClass;
    public final RubyModule truffleTypeModule;
    public final RubyModule truffleModule;
    public final RubyModule truffleCExtModule;
    public final RubyModule truffleInternalModule;
    public final RubyModule truffleBootModule;
    public final RubyModule truffleExceptionOperationsModule;
    public final RubyModule truffleInteropModule;
    public final RubyClass unsupportedMessageExceptionClass;
    public final RubyClass invalidArrayIndexExceptionClass;
    public final RubyClass unknownIdentifierExceptionClass;
    public final RubyClass unsupportedTypeExceptionClass;
    public final RubyClass arityExceptionClass;
    public final RubyClass unknownKeyExceptionClass;
    public final RubyClass sourceLocationClass;
    public final RubyModule truffleFeatureLoaderModule;
    public final RubyModule truffleKernelOperationsModule;
    public final RubyModule truffleInteropOperationsModule;
    public final RubyModule truffleStringOperationsModule;
    public final RubyModule truffleRegexpOperationsModule;
    public final RubyModule truffleRandomOperationsModule;
    public final RubyModule truffleThreadOperationsModule;
    public final RubyModule truffleWarningOperationsModule;
    public final RubyClass encodingCompatibilityErrorClass;
    public final RubyClass encodingUndefinedConversionErrorClass;
    public final RubyClass methodClass;
    public final RubyClass unboundMethodClass;
    public final RubyClass byteArrayClass;
    public final RubyClass fiberErrorClass;
    public final RubyClass threadErrorClass;
    public final RubyModule objectSpaceModule;
    public final RubyClass randomizerClass;
    public final RubyClass prngRandomizerClass;
    public final RubyClass secureRandomizerClass;
    public final RubyClass customRandomizerClass;
    public final RubyClass handleClass;
    public final RubyClass ioClass;
    public final RubyClass closedQueueErrorClass;
    public final RubyModule warningModule;
    public final RubyClass digestClass;
    public final RubyClass structClass;
    public final RubyClass weakMapClass;
    public final RubyArray argv;
    public final RubyBasicObject mainObject;
    public final GlobalVariables globalVariables;
    public final BindingLocalVariablesObject interactiveBindingLocalVariablesObject;
    public final RubyClass noMatchingPatternErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass eagainWaitReadable;
    @CompilerDirectives.CompilationFinal
    private RubyClass eagainWaitWritable;
    private final Map<String, RubyClass> errnoClasses = new HashMap<String, RubyClass>();
    private final Map<Integer, String> errnoValueToNames = new HashMap<Integer, String>();
    @CompilerDirectives.CompilationFinal
    private SharedMethodInfo truffleBootMainInfo;
    @CompilerDirectives.CompilationFinal
    private GlobalVariableReader debugReader;
    @CompilerDirectives.CompilationFinal
    private GlobalVariableReader verboseReader;
    @CompilerDirectives.CompilationFinal
    private GlobalVariableReader stdinReader;
    @CompilerDirectives.CompilationFinal
    private GlobalVariableReader stderrReader;
    @CompilerDirectives.CompilationFinal
    public RubyBinding topLevelBinding;
    @CompilerDirectives.CompilationFinal
    public RubyBinding interactiveBinding;
    @CompilerDirectives.CompilationFinal
    public TopScopeObject topScopeObject;
    private final ConcurrentMap<String, Boolean> patchFiles;
    private final ConcurrentMap<String, String> originalRequires;
    private DirectCallNode callNodeToCheckSplittingEnabled;
    public State state = State.CREATED;
    private final SingletonClassNode node;
    private static final String POST_BOOT_FILE = "/post-boot/post-boot.rb";
    public static final String[] CORE_FILES = new String[]{"/core/pre.rb", "/core/basic_object.rb", "/core/array.rb", "/core/configuration.rb", "/core/false.rb", "/core/fiber.rb", "/core/gc.rb", "/core/nil.rb", "/core/truffle/platform.rb", "/core/string.rb", "/core/truffle/random_operations.rb", "/core/random.rb", "/core/truffle/versioned_array.rb", "/core/truffle/kernel_operations.rb", "/core/truffle/exception_operations.rb", "/core/truffle/feature_loader.rb", "/core/truffle/gem_util.rb", "/core/truffle/thread_operations.rb", "/core/thread.rb", "/core/true.rb", "/core/type.rb", "/core/module.rb", "/core/refinement.rb", "/core/truffle/ffi/pointer.rb", "/core/truffle/ffi/pointer_access.rb", "/core/truffle/ffi/pointer_extra.rb", "/core/truffle/io_operations.rb", "/core/truffle/internal.rb", "/core/kernel.rb", "/core/lazy_rubygems.rb", "/core/truffle/boot.rb", "/core/truffle/concurrent_map.rb", "/core/truffle/complex_operations.rb", "/core/truffle/debug.rb", "/core/truffle/diggable.rb", "/core/truffle/encoding_operations.rb", "/core/truffle/enumerable_operations.rb", "/core/truffle/enumerator_operations.rb", "/core/truffle/hash_operations.rb", "/core/truffle/interop_operations.rb", "/core/truffle/numeric_operations.rb", "/core/truffle/proc_operations.rb", "/core/truffle/range_operations.rb", "/core/truffle/regexp_operations.rb", "/core/truffle/stat_operations.rb", "/core/truffle/string_operations.rb", "/core/truffle/backward.rb", "/core/truffle/time_operations.rb", "/core/truffle/truffleruby.rb", "/core/splitter.rb", "/core/stat.rb", "/core/io.rb", "/core/proc.rb", "/core/enumerable.rb", "/core/enumerator.rb", "/core/argf.rb", "/core/exception.rb", "/core/hash.rb", "/core/comparable.rb", "/core/numeric.rb", "/core/truffle/ctype.rb", "/core/truffle/integer_operations.rb", "/core/integer.rb", "/core/match_data.rb", "/core/regexp.rb", "/core/transcoding.rb", "/core/encoding.rb", "/core/env.rb", "/core/errno.rb", "/core/truffle/file_operations.rb", "/core/file.rb", "/core/truffle/dir_operations.rb", "/core/dir.rb", "/core/dir_glob.rb", "/core/file_test.rb", "/core/truffle/float_operations.rb", "/core/float.rb", "/core/marshal.rb", "/core/object_space.rb", "/core/range.rb", "/core/struct.rb", "/core/tms.rb", "/core/process.rb", "/core/truffle/process_operations.rb", "/core/signal.rb", "/core/symbol.rb", "/core/mutex.rb", "/core/throw_catch.rb", "/core/time.rb", "/core/rational.rb", "/core/rationalizer.rb", "/core/complex.rb", "/core/complexifier.rb", "/core/class.rb", "/core/binding.rb", "/core/math.rb", "/core/truffle/method_operations.rb", "/core/method.rb", "/core/unbound_method.rb", "/core/truffle/warning_operations.rb", "/core/warning.rb", "/core/weakmap.rb", "/core/tracepoint.rb", "/core/truffle/interop.rb", "/core/truffle/polyglot.rb", "/core/truffle/polyglot_methods.rb", "/core/posix.rb", "/core/data.rb", "/core/truffle/queue_operations.rb", "/core/main.rb", "/core/post.rb", "/post-boot/post-boot.rb"};

    @CompilerDirectives.TruffleBoundary
    private static SourceSection initCoreSourceSection() {
        Source source;
        Source.LiteralBuilder builder = Source.newBuilder((String)"ruby", (CharSequence)"", (String)"(core)");
        builder.internal(false);
        try {
            source = builder.build();
        }
        catch (IOException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
        return source.createUnavailableSection();
    }

    public CoreLibrary(RubyContext context, RubyLanguage language) {
        this.context = context;
        this.language = language;
        this.node = SingletonClassNode.getUncached();
        this.classClass = ClassNodes.createClassClassAndBootClasses(language);
        this.moduleClass = (RubyClass)this.classClass.superclass;
        this.objectClass = (RubyClass)this.moduleClass.superclass;
        this.basicObjectClass = (RubyClass)this.objectClass.superclass;
        this.objectClass.fields.setConstant(context, this.node, "Class", this.classClass);
        this.objectClass.fields.setConstant(context, this.node, "BasicObject", this.basicObjectClass);
        this.objectClass.fields.setConstant(context, this.node, "Object", this.objectClass);
        this.objectClass.fields.setConstant(context, this.node, "Module", this.moduleClass);
        this.exceptionClass = this.defineClass("Exception");
        this.defineClass(this.exceptionClass, "fatal");
        this.noMemoryErrorClass = this.defineClass(this.exceptionClass, "NoMemoryError");
        this.standardErrorClass = this.defineClass(this.exceptionClass, "StandardError");
        this.argumentErrorClass = this.defineClass(this.standardErrorClass, "ArgumentError");
        this.encodingErrorClass = this.defineClass(this.standardErrorClass, "EncodingError");
        this.fiberErrorClass = this.defineClass(this.standardErrorClass, "FiberError");
        this.ioErrorClass = this.defineClass(this.standardErrorClass, "IOError");
        this.localJumpErrorClass = this.defineClass(this.standardErrorClass, "LocalJumpError");
        this.regexpErrorClass = this.defineClass(this.standardErrorClass, "RegexpError");
        this.threadErrorClass = this.defineClass(this.standardErrorClass, "ThreadError");
        this.typeErrorClass = this.defineClass(this.standardErrorClass, "TypeError");
        this.zeroDivisionErrorClass = this.defineClass(this.standardErrorClass, "ZeroDivisionError");
        this.polyglotModule = this.defineModule("Polyglot");
        this.polyglotInnerContextClass = this.defineClass(this.polyglotModule, this.objectClass, "InnerContext");
        this.unsupportedMessageErrorClass = this.defineClass(this.polyglotModule, this.standardErrorClass, "UnsupportedMessageError");
        this.polyglotForeignObjectClass = this.defineClass(this.polyglotModule, this.objectClass, "ForeignObject");
        this.polyglotForeignClasses = new RubyClass[ForeignClassNode.Trait.COMBINATIONS];
        this.noMatchingPatternErrorClass = this.defineClass(this.standardErrorClass, "NoMatchingPatternError");
        this.runtimeErrorClass = this.defineClass(this.standardErrorClass, "RuntimeError");
        this.frozenErrorClass = this.defineClass(this.runtimeErrorClass, "FrozenError");
        this.rangeErrorClass = this.defineClass(this.standardErrorClass, "RangeError");
        this.floatDomainErrorClass = this.defineClass(this.rangeErrorClass, "FloatDomainError");
        this.indexErrorClass = this.defineClass(this.standardErrorClass, "IndexError");
        this.keyErrorClass = this.defineClass(this.indexErrorClass, "KeyError");
        this.stopIterationClass = this.defineClass(this.indexErrorClass, "StopIteration");
        this.closedQueueErrorClass = this.defineClass(this.stopIterationClass, "ClosedQueueError");
        this.defineClass(this.ioErrorClass, "EOFError");
        this.nameErrorClass = this.defineClass(this.standardErrorClass, "NameError");
        this.noMethodErrorClass = this.defineClass(this.nameErrorClass, "NoMethodError");
        this.systemCallErrorClass = this.defineClass(this.standardErrorClass, "SystemCallError");
        this.errnoModule = this.defineModule("Errno");
        RubyClass scriptErrorClass = this.defineClass(this.exceptionClass, "ScriptError");
        this.loadErrorClass = this.defineClass(scriptErrorClass, "LoadError");
        this.notImplementedErrorClass = this.defineClass(scriptErrorClass, "NotImplementedError");
        this.syntaxErrorClass = this.defineClass(scriptErrorClass, "SyntaxError");
        this.securityErrorClass = this.defineClass(this.exceptionClass, "SecurityError");
        this.signalExceptionClass = this.defineClass(this.exceptionClass, "SignalException");
        this.defineClass(this.signalExceptionClass, "Interrupt");
        this.systemExitClass = this.defineClass(this.exceptionClass, "SystemExit");
        this.systemStackErrorClass = this.defineClass(this.exceptionClass, "SystemStackError");
        this.numericClass = this.defineClass("Numeric");
        this.complexClass = this.defineClass(this.numericClass, "Complex");
        this.floatClass = this.defineClass(this.numericClass, "Float");
        this.integerClass = this.defineClass(this.numericClass, "Integer");
        this.rationalClass = this.defineClass(this.numericClass, "Rational");
        this.arrayClass = this.defineClass("Array");
        this.bindingClass = this.defineClass("Binding");
        this.defineClass("ConditionVariable");
        this.dirClass = this.defineClass("Dir");
        this.encodingClass = this.defineClass("Encoding");
        this.enumeratorClass = this.defineClass("Enumerator");
        this.arithmeticSequenceClass = this.defineClass(this.enumeratorClass, this.enumeratorClass, "ArithmeticSequence");
        this.falseClass = this.defineClass("FalseClass");
        this.fiberClass = this.defineClass("Fiber");
        this.defineModule("FileTest");
        this.hashClass = this.defineClass("Hash");
        this.matchDataClass = this.defineClass("MatchData");
        this.methodClass = this.defineClass("Method");
        this.defineClass("Mutex");
        this.nilClass = this.defineClass("NilClass");
        this.procClass = this.defineClass("Proc");
        this.processModule = this.defineModule("Process");
        RubyClass queueClass = this.defineClass("Queue");
        this.defineClass(queueClass, "SizedQueue");
        this.rangeClass = this.defineClass("Range");
        this.regexpClass = this.defineClass("Regexp");
        this.refinementClass = this.defineClass(this.moduleClass, "Refinement");
        this.stringClass = this.defineClass("String");
        this.symbolClass = this.defineClass("Symbol");
        this.threadClass = this.defineClass("Thread");
        DynamicObjectLibrary.getUncached().put((DynamicObject)this.threadClass, (Object)"@report_on_exception", (Object)true);
        DynamicObjectLibrary.getUncached().put((DynamicObject)this.threadClass, (Object)"@abort_on_exception", (Object)false);
        RubyClass threadBacktraceClass = this.defineClass(this.threadClass, this.objectClass, "Backtrace");
        this.threadBacktraceLocationClass = this.defineClass(threadBacktraceClass, this.objectClass, "Location");
        this.defineClass("Time");
        this.trueClass = this.defineClass("TrueClass");
        this.unboundMethodClass = this.defineClass("UnboundMethod");
        this.ioClass = this.defineClass("IO");
        this.defineClass(this.ioClass, "File");
        this.structClass = this.defineClass("Struct");
        this.defineClass("TracePoint");
        RubyModule comparableModule = this.defineModule("Comparable");
        this.enumerableModule = this.defineModule("Enumerable");
        this.defineModule("GC");
        this.kernelModule = this.defineModule("Kernel");
        RubyModule mathModule = this.defineModule("Math");
        this.mathDomainErrorClass = this.defineClass(mathModule, this.standardErrorClass, "DomainError");
        this.objectSpaceModule = this.defineModule("ObjectSpace");
        this.weakMapClass = this.defineClass(this.objectSpaceModule, this.objectClass, "WeakMap");
        this.encodingCompatibilityErrorClass = this.defineClass(this.encodingClass, this.encodingErrorClass, "CompatibilityError");
        this.encodingUndefinedConversionErrorClass = this.defineClass(this.encodingClass, this.encodingErrorClass, "UndefinedConversionError");
        this.encodingConverterClass = this.defineClass(this.encodingClass, this.objectClass, "Converter");
        RubyModule truffleRubyModule = this.defineModule("TruffleRuby");
        this.defineClass(truffleRubyModule, this.objectClass, "AtomicReference");
        this.defineClass(truffleRubyModule, this.objectClass, "ConcurrentMap");
        this.truffleModule = this.defineModule("Truffle");
        this.truffleInternalModule = this.defineModule(this.truffleModule, "Internal");
        this.graalErrorClass = this.defineClass(this.truffleModule, this.exceptionClass, "GraalError");
        this.truffleExceptionOperationsModule = this.defineModule(this.truffleModule, "ExceptionOperations");
        this.truffleInteropModule = this.defineModule(this.truffleModule, "Interop");
        RubyClass interopExceptionClass = this.defineClass(this.truffleInteropModule, this.exceptionClass, "InteropException");
        this.unsupportedMessageExceptionClass = this.defineClass(this.truffleInteropModule, interopExceptionClass, "UnsupportedMessageException");
        this.invalidArrayIndexExceptionClass = this.defineClass(this.truffleInteropModule, interopExceptionClass, "InvalidArrayIndexException");
        this.unknownIdentifierExceptionClass = this.defineClass(this.truffleInteropModule, interopExceptionClass, "UnknownIdentifierException");
        this.unsupportedTypeExceptionClass = this.defineClass(this.truffleInteropModule, interopExceptionClass, "UnsupportedTypeException");
        this.arityExceptionClass = this.defineClass(this.truffleInteropModule, interopExceptionClass, "ArityException");
        this.unknownKeyExceptionClass = this.defineClass(this.truffleInteropModule, interopExceptionClass, "UnknownKeyException");
        this.sourceLocationClass = this.defineClass(this.truffleInteropModule, this.objectClass, "SourceLocation");
        this.truffleCExtModule = this.defineModule(this.truffleModule, "CExt");
        this.defineModule(this.truffleModule, "Debug");
        this.defineModule(this.truffleModule, "ObjSpace");
        this.defineModule(this.truffleModule, "Coverage");
        this.defineModule(this.truffleModule, "Graal");
        this.truffleRegexpOperationsModule = this.defineModule(this.truffleModule, "RegexpOperations");
        this.truffleStringOperationsModule = this.defineModule(this.truffleModule, "StringOperations");
        this.truffleBootModule = this.defineModule(this.truffleModule, "Boot");
        this.defineModule(this.truffleModule, "System");
        this.truffleFeatureLoaderModule = this.defineModule(this.truffleModule, "FeatureLoader");
        this.truffleKernelOperationsModule = this.defineModule(this.truffleModule, "KernelOperations");
        this.truffleInteropOperationsModule = this.defineModule(this.truffleModule, "InteropOperations");
        this.defineModule(this.truffleModule, "MonitorOperations");
        this.defineModule(this.truffleModule, "Binding");
        this.defineModule(this.truffleModule, "POSIX");
        this.defineModule(this.truffleModule, "Readline");
        this.defineModule(this.truffleModule, "ReadlineHistory");
        this.truffleRandomOperationsModule = this.defineModule(this.truffleModule, "RandomOperations");
        this.truffleThreadOperationsModule = this.defineModule(this.truffleModule, "ThreadOperations");
        this.truffleWarningOperationsModule = this.defineModule(this.truffleModule, "WarningOperations");
        this.defineModule(this.truffleModule, "WeakRefOperations");
        this.handleClass = this.defineClass(this.truffleModule, this.objectClass, "Handle");
        this.warningModule = this.defineModule("Warning");
        this.truffleFFIModule = this.defineModule(this.truffleModule, "FFI");
        RubyClass truffleFFIAbstractMemoryClass = this.defineClass(this.truffleFFIModule, this.objectClass, "AbstractMemory");
        this.truffleFFIPointerClass = this.defineClass(this.truffleFFIModule, truffleFFIAbstractMemoryClass, "Pointer");
        this.truffleFFINullPointerErrorClass = this.defineClass(this.truffleFFIModule, this.runtimeErrorClass, "NullPointerError");
        this.truffleTypeModule = this.defineModule(this.truffleModule, "Type");
        this.byteArrayClass = this.defineClass(this.truffleModule, this.objectClass, "ByteArray");
        this.defineClass(this.truffleModule, this.objectClass, "StringData");
        this.defineClass(this.encodingClass, this.objectClass, "Transcoding");
        this.randomizerClass = this.defineClass(this.truffleModule, this.objectClass, "Randomizer");
        this.prngRandomizerClass = this.defineClass(this.truffleModule, this.randomizerClass, "PRNGRandomizer");
        this.secureRandomizerClass = this.defineClass(this.truffleModule, this.randomizerClass, "SecureRandomizer");
        this.customRandomizerClass = this.defineClass(this.truffleModule, this.randomizerClass, "CustomRandomizer");
        this.digestClass = this.defineClass(this.truffleModule, this.basicObjectClass, "Digest");
        this.includeModules(comparableModule);
        this.mainObject = new RubyBasicObject(this.objectClass, language.basicObjectShape);
        this.argv = new RubyArray(this.arrayClass, language.arrayShape, ArrayStoreLibrary.initialStorage(false), 0);
        this.globalVariables = new GlobalVariables(context);
        this.interactiveBindingLocalVariablesObject = new BindingLocalVariablesObject();
        this.topScopeObject = new TopScopeObject(new Object[]{this.interactiveBindingLocalVariablesObject, new GlobalVariablesObject(this.globalVariables), this.mainObject});
        this.patchFiles = this.initializePatching(context);
        this.originalRequires = new ConcurrentHashMap<String, String>();
    }

    @SuppressFBWarnings(value={"SIC"})
    private ConcurrentMap<String, Boolean> initializePatching(RubyContext context) {
        this.defineModule(this.truffleModule, "Patching");
        final ConcurrentHashMap<String, Boolean> patchFiles = new ConcurrentHashMap<String, Boolean>();
        String rubyHome = this.language.getRubyHome();
        if (context.getOptions().PATCHING) {
            try {
                final Path patchesDirectory = Paths.get(rubyHome, "lib", "patches");
                Files.walkFileTree(patchesDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){
                    final /* synthetic */ CoreLibrary this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                        String relativePath = patchesDirectory.relativize(path).toString();
                        if (relativePath.endsWith(".rb")) {
                            patchFiles.put(relativePath.substring(0, relativePath.length() - 3), false);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return patchFiles;
    }

    private void includeModules(RubyModule comparableModule) {
        this.objectClass.fields.include(this.context, this.node, this.kernelModule);
        this.numericClass.fields.include(this.context, this.node, comparableModule);
        this.symbolClass.fields.include(this.context, this.node, comparableModule);
        this.arrayClass.fields.include(this.context, this.node, this.enumerableModule);
        this.dirClass.fields.include(this.context, this.node, this.enumerableModule);
        this.hashClass.fields.include(this.context, this.node, this.enumerableModule);
        this.rangeClass.fields.include(this.context, this.node, this.enumerableModule);
        this.weakMapClass.fields.include(this.context, this.node, this.enumerableModule);
    }

    public void initialize() {
        this.initializeConstants();
    }

    public void loadCoreNodes() {
        this.state = State.INITIALIZING;
        CoreMethodNodeManager coreMethodNodeManager = new CoreMethodNodeManager(this.context);
        coreMethodNodeManager.loadCoreMethodNodes();
        this.truffleBootMainInfo = this.getMethod(this.node.execute(this.truffleBootModule), "main").getSharedMethodInfo();
    }

    private InternalMethod getMethod(RubyModule module, String name) {
        InternalMethod method = module.fields.getMethod(name);
        if (method == null || method.isUndefined()) {
            throw new Error("method " + String.valueOf(module) + "#" + name + " not found during CoreLibrary initialization");
        }
        return method;
    }

    private Object verbosityOption() {
        switch (this.context.getOptions().VERBOSITY) {
            case NIL: {
                return Nil.INSTANCE;
            }
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private void findGlobalVariableStorage() {
        this.debugReader = this.globalVariables.getReader("$DEBUG");
        this.verboseReader = this.globalVariables.getReader("$VERBOSE");
        this.stdinReader = this.globalVariables.getReader("$stdin");
        this.stderrReader = this.globalVariables.getReader("$stderr");
    }

    private void initializeConstants() {
        this.setConstant(this.truffleFFIModule, "TYPE_CHAR", 0);
        this.setConstant(this.truffleFFIModule, "TYPE_UCHAR", 1);
        this.setConstant(this.truffleFFIModule, "TYPE_BOOL", 2);
        this.setConstant(this.truffleFFIModule, "TYPE_SHORT", 3);
        this.setConstant(this.truffleFFIModule, "TYPE_USHORT", 4);
        this.setConstant(this.truffleFFIModule, "TYPE_INT", 5);
        this.setConstant(this.truffleFFIModule, "TYPE_UINT", 6);
        this.setConstant(this.truffleFFIModule, "TYPE_LONG", 7);
        this.setConstant(this.truffleFFIModule, "TYPE_ULONG", 8);
        this.setConstant(this.truffleFFIModule, "TYPE_LL", 9);
        this.setConstant(this.truffleFFIModule, "TYPE_ULL", 10);
        this.setConstant(this.truffleFFIModule, "TYPE_FLOAT", 11);
        this.setConstant(this.truffleFFIModule, "TYPE_DOUBLE", 12);
        this.setConstant(this.truffleFFIModule, "TYPE_PTR", 13);
        this.setConstant(this.truffleFFIModule, "TYPE_VOID", 14);
        this.setConstant(this.truffleFFIModule, "TYPE_STRING", 15);
        this.setConstant(this.truffleFFIModule, "TYPE_STRPTR", 16);
        this.setConstant(this.truffleFFIModule, "TYPE_CHARARR", 17);
        this.setConstant(this.truffleFFIModule, "TYPE_ENUM", 18);
        this.setConstant(this.truffleFFIModule, "TYPE_VARARGS", 19);
        this.setConstant(this.truffleFFIPointerClass, "UNBOUNDED", Long.MAX_VALUE);
        this.setConstant(this.objectClass, "RUBY_VERSION", this.frozenUSASCIIString("3.3.5"));
        this.setConstant(this.objectClass, "RUBY_PATCHLEVEL", 0);
        this.setConstant(this.objectClass, "RUBY_REVISION", this.frozenUSASCIIString(TruffleRuby.LANGUAGE_REVISION));
        this.setConstant(this.objectClass, "RUBY_ENGINE", this.frozenUSASCIIString("truffleruby"));
        this.setConstant(this.objectClass, "RUBY_ENGINE_VERSION", this.frozenUSASCIIString(TruffleRuby.getEngineVersion()));
        this.setConstant(this.objectClass, "RUBY_PLATFORM", this.frozenUSASCIIString(TruffleRuby.RUBY_PLATFORM));
        this.setConstant(this.objectClass, "RUBY_RELEASE_DATE", this.frozenUSASCIIString(BuildInformationImpl.INSTANCE.getCompileDate()));
        this.setConstant(this.objectClass, "RUBY_DESCRIPTION", this.frozenUSASCIIString(TruffleRuby.getVersionString((String)Truffle.getRuntime().getName())));
        this.setConstant(this.objectClass, "RUBY_COPYRIGHT", this.frozenUSASCIIString(TruffleRuby.RUBY_COPYRIGHT));
        this.setConstant(this.basicObjectClass, "BasicObject", this.basicObjectClass);
        this.setConstant(this.objectClass, "ARGV", this.argv);
        this.setConstant(this.truffleModule, "UNDEFINED", NotProvided.INSTANCE);
        this.setConstant(this.encodingConverterClass, "INVALID_MASK", 15);
        this.setConstant(this.encodingConverterClass, "INVALID_REPLACE", 2);
        this.setConstant(this.encodingConverterClass, "UNDEF_MASK", 240);
        this.setConstant(this.encodingConverterClass, "UNDEF_REPLACE", 32);
        this.setConstant(this.encodingConverterClass, "UNDEF_HEX_CHARREF", 48);
        this.setConstant(this.encodingConverterClass, "PARTIAL_INPUT", 65536);
        this.setConstant(this.encodingConverterClass, "AFTER_OUTPUT", 131072);
        this.setConstant(this.encodingConverterClass, "UNIVERSAL_NEWLINE_DECORATOR", 256);
        this.setConstant(this.encodingConverterClass, "CRLF_NEWLINE_DECORATOR", 4096);
        this.setConstant(this.encodingConverterClass, "CR_NEWLINE_DECORATOR", 8192);
        this.setConstant(this.encodingConverterClass, "XML_TEXT_DECORATOR", 16384);
        this.setConstant(this.encodingConverterClass, "XML_ATTR_CONTENT_DECORATOR", 32768);
        this.setConstant(this.encodingConverterClass, "XML_ATTR_QUOTE_DECORATOR", 0x100000);
        for (Map.Entry<String, Object> entry : this.context.getNativeConfiguration().getSection(ERRNO_CONFIG_PREFIX)) {
            RubyClass rubyClass;
            String name = entry.getKey().substring(ERRNO_CONFIG_PREFIX.length());
            int errno = (Integer)entry.getValue();
            String alreadyDefined = this.errnoValueToNames.putIfAbsent(errno, name);
            if (alreadyDefined != null) {
                rubyClass = this.errnoClasses.get(alreadyDefined);
                this.setConstant(this.errnoModule, name, rubyClass);
            } else {
                rubyClass = this.defineClass(this.errnoModule, this.systemCallErrorClass, name);
                this.setConstant(rubyClass, "Errno", entry.getValue());
            }
            this.errnoClasses.put(name, rubyClass);
        }
    }

    private void setConstant(RubyModule module, String name, Object value) {
        module.fields.setConstant(this.context, this.node, name, value);
    }

    private ImmutableRubyString frozenUSASCIIString(String string) {
        return this.language.getFrozenStringLiteral(TStringUtils.usAsciiString(string), Encodings.US_ASCII);
    }

    private RubyClass defineClass(String name) {
        return this.defineClass(this.objectClass, name);
    }

    private RubyClass defineClass(RubyClass superclass, String name) {
        return ClassNodes.createInitializedRubyClass(this.context, null, this.objectClass, superclass, name, this.node);
    }

    private RubyClass defineClass(RubyModule lexicalParent, RubyClass superclass, String name) {
        return ClassNodes.createInitializedRubyClass(this.context, null, lexicalParent, superclass, name, this.node);
    }

    private RubyModule defineModule(String name) {
        return this.defineModule(null, this.objectClass, name);
    }

    private RubyModule defineModule(RubyModule lexicalParent, String name) {
        return this.defineModule(null, lexicalParent, name);
    }

    private RubyModule defineModule(SourceSection sourceSection, RubyModule lexicalParent, String name) {
        return ModuleNodes.createModule(this.context, sourceSection, this.moduleClass, lexicalParent, name, this.node);
    }

    @SuppressFBWarnings(value={"ES"})
    public void loadRubyCoreLibraryAndPostBoot() {
        this.state = State.LOADING_RUBY_CORE;
        try {
            for (String file : CORE_FILES) {
                if (file == POST_BOOT_FILE) {
                    this.afterLoadCoreLibrary();
                    this.state = State.LOADED;
                }
                RubySource rubySource = this.loadCoreFileSource(this.language.coreLoadPath + file);
                Source source = rubySource.getSource();
                RootCallTarget callTarget = this.context.getCodeLoader().parseTopLevelWithCache(rubySource, this.node);
                CodeLoader.DeferredCall deferredCall = this.context.getCodeLoader().prepareExecute(callTarget, ParserContext.TOP_LEVEL, DeclarationContext.topLevel(this.context), null, (Object)this.context.getCoreLibrary().mainObject, this.context.getRootLexicalScope());
                YARPTranslatorDriver.printParseTranslateExecuteMetric("before-execute", this.context, source);
                deferredCall.callWithoutCallNode();
                YARPTranslatorDriver.printParseTranslateExecuteMetric("after-execute", this.context, source);
            }
        }
        catch (IOException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
        catch (Throwable e) {
            System.err.println("\nException while loading core library:");
            throw e;
        }
    }

    public RubySource loadCoreFileSource(String path) throws IOException {
        if (path.startsWith("resource:")) {
            return ResourceLoader.loadResource(path, this.language.options.CORE_AS_INTERNAL);
        }
        FileLoader fileLoader = new FileLoader(this.context, this.language);
        return fileLoader.loadFile(path);
    }

    private void afterLoadCoreLibrary() {
        this.eagainWaitReadable = (RubyClass)this.ioClass.fields.getConstant("EAGAINWaitReadable").getValue();
        this.eagainWaitWritable = (RubyClass)this.ioClass.fields.getConstant("EAGAINWaitWritable").getValue();
        this.findGlobalVariableStorage();
        this.context.initializeMainScriptName("-");
        this.topLevelBinding = (RubyBinding)this.objectClass.fields.getConstant("TOPLEVEL_BINDING").getValue();
        this.interactiveBinding = (RubyBinding)this.truffleBootModule.fields.getConstant("INTERACTIVE_BINDING").getValue();
        this.interactiveBindingLocalVariablesObject.setBinding(this.interactiveBinding);
    }

    public static double toDouble(Object value, Object nil) {
        assert (value != null);
        if (value == nil) {
            return 0.0;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).longValue();
        }
        if (value instanceof RubyBignum) {
            return BigIntegerOps.doubleValue((RubyBignum)value);
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public static boolean fitsIntoInteger(long value) {
        return (long)((int)value) == value;
    }

    public static boolean fitsIntoUnsignedInteger(long value) {
        return value == (value & 0xFFFFFFFFL) || value < 0L && value >= Integer.MIN_VALUE;
    }

    public Object getDebug() {
        if (this.debugReader != null) {
            return this.debugReader.getValue();
        }
        return this.context.getOptions().DEBUG;
    }

    private Object verbosity() {
        if (this.verboseReader != null) {
            return this.verboseReader.getValue();
        }
        return this.verbosityOption();
    }

    public boolean warningsEnabled() {
        return this.verbosity() != Nil.INSTANCE;
    }

    public boolean isVerbose() {
        return this.verbosity() == Boolean.TRUE;
    }

    public Object getStdin() {
        return this.stdinReader.getValue();
    }

    public Object getStderr() {
        return this.stderrReader.getValue();
    }

    public RubyBasicObject getENV() {
        return (RubyBasicObject)((Object)this.objectClass.fields.getConstant("ENV").getValue());
    }

    @CompilerDirectives.TruffleBoundary
    public int getErrnoValue(String errnoName) {
        return (Integer)this.context.getNativeConfiguration().get(ERRNO_CONFIG_PREFIX + errnoName);
    }

    @CompilerDirectives.TruffleBoundary
    public String getErrnoName(int errnoValue) {
        return this.errnoValueToNames.get(errnoValue);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyClass getErrnoClass(String name) {
        return this.errnoClasses.get(name);
    }

    public ConcurrentMap<String, Boolean> getPatchFiles() {
        return this.patchFiles;
    }

    public ConcurrentMap<String, String> getOriginalRequires() {
        return this.originalRequires;
    }

    public boolean isInitializing() {
        return this.state == State.INITIALIZING;
    }

    public boolean isLoadingRubyCore() {
        return this.state == State.LOADING_RUBY_CORE;
    }

    public boolean isLoaded() {
        return this.state == State.LOADED;
    }

    public boolean isTruffleBootMainMethod(SharedMethodInfo info) {
        return info == this.truffleBootMainInfo;
    }

    public boolean isSplittingEnabled() {
        if (this.callNodeToCheckSplittingEnabled == null) {
            this.callNodeToCheckSplittingEnabled = DirectCallNode.create((CallTarget)this.getMethod(this.arrayClass, "[]").getCallTarget());
            this.callNodeToCheckSplittingEnabled.cloneCallTarget();
        }
        return this.callNodeToCheckSplittingEnabled.isCallTargetCloned();
    }

    public static enum State {
        CREATED,
        INITIALIZING,
        LOADING_RUBY_CORE,
        LOADED;

    }
}

