/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;

public final class ReturnEnumeratorIfNoBlockNode
extends RubyContextSourceNode {
    private final String methodName;
    @Node.Child
    private RubyNode method;
    @Node.Child
    private DispatchNode toEnumNode;
    @CompilerDirectives.CompilationFinal
    private RubySymbol methodSymbol;
    private final ConditionProfile noBlockProfile = ConditionProfile.create();

    public ReturnEnumeratorIfNoBlockNode(String methodName, RubyNode method) {
        this.methodName = methodName;
        this.method = method;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object block = RubyArguments.getBlock((Frame)frame);
        if (this.noBlockProfile.profile(block == nil)) {
            if (this.toEnumNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toEnumNode = (DispatchNode)this.insert(DispatchNode.create());
            }
            if (this.methodSymbol == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.methodSymbol = this.getSymbol(this.methodName);
            }
            Object receiver = RubyArguments.getSelf((Frame)frame);
            Object[] rubyArgs = RubyArguments.repack(frame.getArguments(), receiver, 0, 1);
            RubyArguments.setArgument(rubyArgs, 0, this.methodSymbol);
            return this.toEnumNode.execute(null, receiver, "to_enum", rubyArgs, DispatchConfiguration.PRIVATE);
        }
        return this.method.execute(frame);
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReturnEnumeratorIfNoBlockNode copy = new ReturnEnumeratorIfNoBlockNode(this.methodName, this.method.cloneUninitialized());
        return copy.copyFlags(this);
    }
}

