/*
 * Decompiled with CFR 0.152.
 */
package org.prism;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;

public abstract class ParsingOptions {
    public static byte[] serialize(byte[] filepath, int line, byte[] encoding, boolean frozenStringLiteral, EnumSet<CommandLine> commandLine, SyntaxVersion version, boolean encodingLocked, boolean mainScript, boolean partialScript, byte[][][] scopes) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ParsingOptions.write(output, ParsingOptions.serializeInt(filepath.length));
        ParsingOptions.write(output, filepath);
        ParsingOptions.write(output, ParsingOptions.serializeInt(line));
        ParsingOptions.write(output, ParsingOptions.serializeInt(encoding.length));
        ParsingOptions.write(output, encoding);
        output.write(frozenStringLiteral ? 1 : 0);
        output.write(ParsingOptions.serializeEnumSet(commandLine));
        output.write(version.getValue());
        output.write(encodingLocked ? 1 : 0);
        output.write(mainScript ? 1 : 0);
        output.write(partialScript ? 1 : 0);
        ParsingOptions.write(output, ParsingOptions.serializeInt(scopes.length));
        for (byte[][] scope : scopes) {
            ParsingOptions.write(output, ParsingOptions.serializeInt(scope.length));
            for (byte[] local : scope) {
                ParsingOptions.write(output, ParsingOptions.serializeInt(local.length));
                ParsingOptions.write(output, local);
            }
        }
        return output.toByteArray();
    }

    private static void write(ByteArrayOutputStream output, byte[] bytes) {
        output.write(bytes, 0, bytes.length);
    }

    private static <T extends Enum<T>> byte serializeEnumSet(EnumSet<T> set) {
        byte result = 0;
        for (Enum value : set) {
            assert (1 << value.ordinal() <= 127);
            result = (byte)(result | (byte)(1 << value.ordinal()));
        }
        return result;
    }

    private static byte[] serializeInt(int n) {
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder());
        buffer.putInt(n);
        return buffer.array();
    }

    public static enum SyntaxVersion {
        LATEST(0),
        V3_3(1);

        private final int value;

        private SyntaxVersion(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)this.value;
        }
    }

    public static enum CommandLine {
        A,
        E,
        L,
        N,
        P,
        X;

    }
}

