# frozen_string_literal: true

# Copyright (c) 2021, 2024 Oracle and/or its affiliates. All rights reserved. This
# code is released under a tri EPL/GPL/LGPL license. You can use it,
# redistribute it and/or modify it under the terms of the:
#
# Eclipse Public License version 2.0, or
# GNU General Public License version 2, or
# GNU Lesser General Public License version 2.1.

# GENERATED BY tool/generate-versioned-array.rb

# This class is used for $LOADED_FEATURES and $LOAD_PATH.

class Truffle::VersionedArray < Array
  # the monitor must be owned when calling this method
  attr_reader :version

  def initialize(lock)
    @lock = lock
    @version = 0
  end

  def <<(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def []=(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def append(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def clear(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def collect!(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def compact!(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def concat(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def delete(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def delete_at(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def delete_if(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def fill(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def filter!(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def flatten!(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def insert(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def keep_if(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def map!(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def pop(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def prepend(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def push(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def reject!(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def replace(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def reverse!(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def rotate!(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def select!(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def shift(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def shuffle!(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def slice!(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def sort!(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def sort_by!(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def uniq!(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def unshift(*args, &block)
    TruffleRuby.synchronized(@lock) { @version += 1; super(*args, &block) }
  end

  def &(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.&(*args, &block)
  end

  def *(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.*(*args, &block)
  end

  def +(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.+(*args, &block)
  end

  def -(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.-(*args, &block)
  end

  def <=>(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.<=>(*args, &block)
  end

  def ==(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.==(*args, &block)
  end

  def [](*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.[](*args, &block)
  end

  def all?(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.all?(*args, &block)
  end

  def any?(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.any?(*args, &block)
  end

  def assoc(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.assoc(*args, &block)
  end

  def at(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.at(*args, &block)
  end

  def bsearch(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.bsearch(*args, &block)
  end

  def bsearch_index(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.bsearch_index(*args, &block)
  end

  def chain(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.chain(*args, &block)
  end

  def chunk(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.chunk(*args, &block)
  end

  def chunk_while(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.chunk_while(*args, &block)
  end

  def collect(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.collect(*args, &block)
  end

  def collect_concat(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.collect_concat(*args, &block)
  end

  def combination(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.combination(*args, &block)
  end

  def compact(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.compact(*args, &block)
  end

  def count(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.count(*args, &block)
  end

  def cycle(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.cycle(*args, &block)
  end

  def deconstruct(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.deconstruct(*args, &block)
  end

  def detect(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.detect(*args, &block)
  end

  def difference(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.difference(*args, &block)
  end

  def dig(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.dig(*args, &block)
  end

  def drop(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.drop(*args, &block)
  end

  def drop_while(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.drop_while(*args, &block)
  end

  def each(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.each(*args, &block)
  end

  def each_cons(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.each_cons(*args, &block)
  end

  def each_entry(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.each_entry(*args, &block)
  end

  def each_index(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.each_index(*args, &block)
  end

  def each_slice(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.each_slice(*args, &block)
  end

  def each_with_index(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.each_with_index(*args, &block)
  end

  def each_with_object(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.each_with_object(*args, &block)
  end

  def empty?(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.empty?(*args, &block)
  end

  def entries(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.entries(*args, &block)
  end

  def eql?(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.eql?(*args, &block)
  end

  def fetch(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.fetch(*args, &block)
  end

  def filter(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.filter(*args, &block)
  end

  def filter_map(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.filter_map(*args, &block)
  end

  def find(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.find(*args, &block)
  end

  def find_all(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.find_all(*args, &block)
  end

  def find_index(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.find_index(*args, &block)
  end

  def first(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.first(*args, &block)
  end

  def flat_map(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.flat_map(*args, &block)
  end

  def flatten(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.flatten(*args, &block)
  end

  def grep(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.grep(*args, &block)
  end

  def grep_v(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.grep_v(*args, &block)
  end

  def group_by(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.group_by(*args, &block)
  end

  def hash(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.hash(*args, &block)
  end

  def include?(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.include?(*args, &block)
  end

  def index(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.index(*args, &block)
  end

  def inject(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.inject(*args, &block)
  end

  def inspect(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.inspect(*args, &block)
  end

  def intersect?(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.intersect?(*args, &block)
  end

  def intersection(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.intersection(*args, &block)
  end

  def join(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.join(*args, &block)
  end

  def last(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.last(*args, &block)
  end

  def lazy(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.lazy(*args, &block)
  end

  def length(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.length(*args, &block)
  end

  def map(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.map(*args, &block)
  end

  def max(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.max(*args, &block)
  end

  def max_by(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.max_by(*args, &block)
  end

  def member?(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.member?(*args, &block)
  end

  def min(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.min(*args, &block)
  end

  def min_by(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.min_by(*args, &block)
  end

  def minmax(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.minmax(*args, &block)
  end

  def minmax_by(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.minmax_by(*args, &block)
  end

  def none?(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.none?(*args, &block)
  end

  def one?(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.one?(*args, &block)
  end

  def pack(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.pack(*args, &block)
  end

  def partition(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.partition(*args, &block)
  end

  def permutation(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.permutation(*args, &block)
  end

  def product(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.product(*args, &block)
  end

  def rassoc(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.rassoc(*args, &block)
  end

  def reduce(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.reduce(*args, &block)
  end

  def reject(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.reject(*args, &block)
  end

  def repeated_combination(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.repeated_combination(*args, &block)
  end

  def repeated_permutation(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.repeated_permutation(*args, &block)
  end

  def reverse(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.reverse(*args, &block)
  end

  def reverse_each(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.reverse_each(*args, &block)
  end

  def rindex(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.rindex(*args, &block)
  end

  def rotate(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.rotate(*args, &block)
  end

  def sample(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.sample(*args, &block)
  end

  def select(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.select(*args, &block)
  end

  def shuffle(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.shuffle(*args, &block)
  end

  def size(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.size(*args, &block)
  end

  def slice(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.slice(*args, &block)
  end

  def slice_after(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.slice_after(*args, &block)
  end

  def slice_before(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.slice_before(*args, &block)
  end

  def slice_when(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.slice_when(*args, &block)
  end

  def sort(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.sort(*args, &block)
  end

  def sort_by(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.sort_by(*args, &block)
  end

  def sum(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.sum(*args, &block)
  end

  def take(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.take(*args, &block)
  end

  def take_while(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.take_while(*args, &block)
  end

  def tally(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.tally(*args, &block)
  end

  def to_a(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.to_a(*args, &block)
  end

  def to_ary(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.to_ary(*args, &block)
  end

  def to_h(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.to_h(*args, &block)
  end

  def to_s(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.to_s(*args, &block)
  end

  def to_set(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.to_set(*args, &block)
  end

  def transpose(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.transpose(*args, &block)
  end

  def union(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.union(*args, &block)
  end

  def uniq(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.uniq(*args, &block)
  end

  def values_at(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.values_at(*args, &block)
  end

  def zip(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.zip(*args, &block)
  end

  def |(*args, &block)
    copy = TruffleRuby.synchronized(@lock) { Array.new self }
    copy.|(*args, &block)
  end

end
