/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.stdlib.readline;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.graalvm.shadowed.org.jline.terminal.Attributes;
import org.graalvm.shadowed.org.jline.terminal.Size;
import org.graalvm.shadowed.org.jline.terminal.Terminal;
import org.graalvm.shadowed.org.jline.terminal.impl.AbstractTerminal;
import org.graalvm.shadowed.org.jline.utils.NonBlocking;
import org.graalvm.shadowed.org.jline.utils.NonBlockingInputStream;
import org.graalvm.shadowed.org.jline.utils.NonBlockingReader;

public final class SingleThreadTerminal
extends AbstractTerminal {
    private final NonBlockingInputStream input;
    private final NonBlockingReader reader;
    private final OutputStream output;
    private final PrintWriter writer;
    private final Attributes attributes;
    private final Size size;

    public SingleThreadTerminal(String name, String type, NonBlockingInputStream input, OutputStream output, Charset encoding, Attributes attributes, Size size) throws IOException {
        super(name, type, encoding, Terminal.SignalHandler.SIG_DFL);
        this.input = input;
        this.reader = NonBlocking.nonBlocking((String)this.getName(), (InputStream)input, (Charset)this.encoding());
        this.output = output;
        this.writer = new PrintWriter(new OutputStreamWriter(output, this.encoding()));
        this.attributes = attributes;
        this.size = size;
    }

    public InputStream input() {
        return this.input;
    }

    public NonBlockingReader reader() {
        return this.reader;
    }

    public OutputStream output() {
        return this.output;
    }

    public PrintWriter writer() {
        return this.writer;
    }

    public Attributes getAttributes() {
        Attributes copy = new Attributes();
        copy.copy(this.attributes);
        return copy;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes.copy(attributes);
    }

    public Size getSize() {
        Size copy = new Size();
        copy.copy(this.size);
        return copy;
    }

    public void setSize(Size size) {
        this.size.copy(size);
    }
}

