/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.stdlib;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongArray;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.collections.ConcurrentOperations;
import org.truffleruby.options.LanguageOptions;

public final class CoverageManager {
    public static final long NO_CODE = -1L;
    private final Instrumenter instrumenter;
    private EventBinding<?> binding;
    private final Map<Source, AtomicLongArray> counters = new ConcurrentHashMap<Source, AtomicLongArray>();
    private volatile boolean enabled;

    public CoverageManager(LanguageOptions options, Instrumenter instrumenter) {
        this.instrumenter = instrumenter;
        if (options.COVERAGE_GLOBAL) {
            this.enable();
        }
    }

    private int lineToIndex(int line) {
        return line - 1;
    }

    public void setLineHasCode(Source source, int line) {
        AtomicLongArray counters = this.getCounters(source);
        counters.set(this.lineToIndex(line), 0L);
    }

    private boolean getLineHasCode(Source source, int line) {
        AtomicLongArray counters = this.getCounters(source);
        return counters.get(this.lineToIndex(line)) != -1L;
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void enable() {
        if (this.enabled) {
            return;
        }
        this.binding = this.instrumenter.attachExecutionEventFactory(SourceSectionFilter.newBuilder().mimeTypeIs(new String[]{"application/x-ruby;coverage=true"}).tagIs(new Class[]{LineTag.class}).build(), eventContext -> new ExecutionEventNode(this){
            @CompilerDirectives.CompilationFinal
            private int lineNumber = -2;
            @CompilerDirectives.CompilationFinal
            private AtomicLongArray counters;
            final /* synthetic */ CoverageManager this$0;
            {
                this.this$0 = this$0;
            }

            protected void onEnter(VirtualFrame frame) {
                if (this.lineNumber == -2) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    SourceSection sourceSection = eventContext.getInstrumentedSourceSection();
                    if (this.this$0.getLineHasCode(sourceSection.getSource(), sourceSection.getStartLine())) {
                        this.lineNumber = this.this$0.lineToIndex(sourceSection.getStartLine());
                        this.counters = this.this$0.getCounters(sourceSection.getSource());
                    } else {
                        this.lineNumber = -1;
                    }
                    assert (this.lineNumber != -2);
                }
                if (this.counters != null) {
                    this.incrementAndGet();
                }
            }

            @CompilerDirectives.TruffleBoundary
            @SuppressFBWarnings(value={"UwF"})
            private void incrementAndGet() {
                this.counters.incrementAndGet(this.lineNumber);
            }
        });
        this.enabled = true;
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void disable() {
        if (!this.enabled) {
            return;
        }
        this.binding.dispose();
        this.counters.clear();
        this.enabled = false;
    }

    private AtomicLongArray getCounters(Source source) {
        return ConcurrentOperations.getOrCompute(this.counters, source, s -> {
            long[] initialValues = new long[s.getLineCount()];
            Arrays.fill(initialValues, -1L);
            return new AtomicLongArray(initialValues);
        });
    }

    public synchronized Map<Source, long[]> getCounts() {
        if (!this.enabled) {
            return null;
        }
        HashMap<Source, long[]> counts = new HashMap<Source, long[]>();
        for (Map.Entry<Source, AtomicLongArray> entry : this.counters.entrySet()) {
            long[] array = new long[entry.getValue().length()];
            for (int n = 0; n < array.length; ++n) {
                array[n] = entry.getValue().get(n);
            }
            counts.put(entry.getKey(), array);
        }
        return counts;
    }

    public synchronized void print(RubyLanguage language, PrintStream out) {
        int maxCountDigits = Long.toString(this.getMaxCount()).length();
        String countFormat = "%" + maxCountDigits + "d";
        char[] noCodeChars = new char[maxCountDigits];
        Arrays.fill(noCodeChars, ' ');
        noCodeChars[maxCountDigits - 1] = 45;
        String noCodeString = new String(noCodeChars);
        for (Map.Entry<Source, AtomicLongArray> entry : this.counters.entrySet()) {
            out.println(language.getSourcePath(entry.getKey()));
            for (int n = 0; n < entry.getValue().length(); ++n) {
                String line = entry.getKey().getCharacters(n + 1).toString();
                if (line.length() > 60) {
                    line = line.substring(0, 60);
                }
                out.print("  ");
                long c = entry.getValue().get(n);
                if (c == -1L) {
                    out.print(noCodeString);
                } else {
                    out.printf(countFormat, c);
                }
                out.printf("  %s%n", line);
            }
        }
    }

    private long getMaxCount() {
        long max = 0L;
        for (Map.Entry<Source, AtomicLongArray> entry : this.counters.entrySet()) {
            for (int n = 0; n < entry.getValue().length(); ++n) {
                max = Math.max(max, entry.getValue().get(n));
            }
        }
        return max;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static final class LineTag
    extends Tag {
    }
}

