/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import java.util.List;
import org.prism.AbstractNodeVisitor;
import org.prism.Nodes;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.AssignableNode;
import org.truffleruby.core.array.MultipleAssignmentNode;
import org.truffleruby.core.array.NoopAssignableNode;
import org.truffleruby.core.cast.SplatCastNode;
import org.truffleruby.core.cast.SplatCastNodeGen;
import org.truffleruby.language.RubyNode;
import org.truffleruby.parser.YARPExecutedOnceExpression;
import org.truffleruby.parser.YARPMultiTargetNodeTranslator;
import org.truffleruby.parser.YARPTranslator;

public final class YARPMultiWriteNodeTranslator
extends AbstractNodeVisitor<AssignableNode> {
    private final Nodes.MultiWriteNode node;
    private final RubyLanguage language;
    private final YARPTranslator yarpTranslator;
    private final List<RubyNode> prolog;

    public YARPMultiWriteNodeTranslator(Nodes.MultiWriteNode node, RubyLanguage language, YARPTranslator yarpTranslator) {
        this.node = node;
        this.language = language;
        this.yarpTranslator = yarpTranslator;
        this.prolog = new ArrayList<RubyNode>();
    }

    public RubyNode translate() {
        RubyNode rhsNode = this.node.value.accept(this.yarpTranslator);
        SplatCastNode splatCastNode = SplatCastNodeGen.create(this.language, SplatCastNode.NilBehavior.ARRAY_WITH_NIL, true, null);
        AssignableNode[] preNodes = new AssignableNode[this.node.lefts.length];
        for (int i = 0; i < this.node.lefts.length; ++i) {
            preNodes[i] = this.node.lefts[i].accept(this);
        }
        AssignableNode restNode = this.node.rest != null ? (this.node.rest instanceof Nodes.ImplicitRestNode ? null : this.node.rest.accept(this)) : null;
        AssignableNode[] postNodes = new AssignableNode[this.node.rights.length];
        for (int i = 0; i < this.node.rights.length; ++i) {
            postNodes[i] = this.node.rights[i].accept(this);
        }
        return new MultipleAssignmentNode(this.prolog.toArray(RubyNode.EMPTY_ARRAY), preNodes, restNode, postNodes, splatCastNode, rhsNode);
    }

    @Override
    public AssignableNode visitClassVariableTargetNode(Nodes.ClassVariableTargetNode node) {
        RubyNode rubyNode = node.accept(this.yarpTranslator);
        return ((AssignableNode)((Object)rubyNode)).toAssignableNode();
    }

    @Override
    public AssignableNode visitCallTargetNode(Nodes.CallTargetNode node) {
        Nodes.Node readReceiver = this.stash(node.receiver, "receiver");
        node = new Nodes.CallTargetNode(node.flags, readReceiver, node.name, node.startOffset, node.length);
        RubyNode rubyNode = node.accept(this.yarpTranslator);
        return ((AssignableNode)((Object)rubyNode)).toAssignableNode();
    }

    @Override
    public AssignableNode visitConstantPathTargetNode(Nodes.ConstantPathTargetNode node) {
        if (node.parent != null) {
            Nodes.Node readParent = this.stash(node.parent, "parent");
            node = new Nodes.ConstantPathTargetNode(readParent, node.name, node.startOffset, node.length);
        }
        RubyNode rubyNode = node.accept(this.yarpTranslator);
        return ((AssignableNode)((Object)rubyNode)).toAssignableNode();
    }

    @Override
    public AssignableNode visitConstantTargetNode(Nodes.ConstantTargetNode node) {
        RubyNode rubyNode = node.accept(this.yarpTranslator);
        return ((AssignableNode)((Object)rubyNode)).toAssignableNode();
    }

    @Override
    public AssignableNode visitGlobalVariableTargetNode(Nodes.GlobalVariableTargetNode node) {
        RubyNode rubyNode = node.accept(this.yarpTranslator);
        return ((AssignableNode)((Object)rubyNode)).toAssignableNode();
    }

    @Override
    public AssignableNode visitImplicitRestNode(Nodes.ImplicitRestNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in #translate");
    }

    @Override
    public AssignableNode visitIndexTargetNode(Nodes.IndexTargetNode node) {
        Nodes.ArgumentsNode arguments;
        Nodes.Node readReceiver = this.stash(node.receiver, "receiver");
        if (node.arguments != null) {
            Nodes.Node[] argumentsReads = new Nodes.Node[node.arguments.arguments.length];
            for (int i = 0; i < node.arguments.arguments.length; ++i) {
                argumentsReads[i] = this.stash(node.arguments.arguments[i], "argument");
            }
            arguments = new Nodes.ArgumentsNode(node.arguments.flags, argumentsReads, node.arguments.startOffset, node.arguments.length);
        } else {
            arguments = null;
        }
        node = new Nodes.IndexTargetNode(node.flags, readReceiver, arguments, node.block, node.startOffset, node.length);
        RubyNode rubyNode = node.accept(this.yarpTranslator);
        return ((AssignableNode)((Object)rubyNode)).toAssignableNode();
    }

    @Override
    public AssignableNode visitInstanceVariableTargetNode(Nodes.InstanceVariableTargetNode node) {
        RubyNode rubyNode = node.accept(this.yarpTranslator);
        return ((AssignableNode)((Object)rubyNode)).toAssignableNode();
    }

    @Override
    public AssignableNode visitLocalVariableTargetNode(Nodes.LocalVariableTargetNode node) {
        RubyNode rubyNode = node.accept(this.yarpTranslator);
        return ((AssignableNode)((Object)rubyNode)).toAssignableNode();
    }

    @Override
    public AssignableNode visitMultiTargetNode(Nodes.MultiTargetNode node) {
        YARPMultiTargetNodeTranslator translator = new YARPMultiTargetNodeTranslator(node, this.language, this.yarpTranslator, null);
        MultipleAssignmentNode multipleAssignmentNode = translator.translate();
        this.prolog.addAll(translator.prolog);
        return multipleAssignmentNode.toAssignableNode();
    }

    @Override
    public AssignableNode visitSplatNode(Nodes.SplatNode node) {
        if (node.expression != null) {
            RubyNode rubyNode = node.expression.accept(this.yarpTranslator);
            return ((AssignableNode)((Object)rubyNode)).toAssignableNode();
        }
        return new NoopAssignableNode();
    }

    @Override
    protected AssignableNode defaultVisit(Nodes.Node node) {
        throw new Error("Unknown node: " + String.valueOf(node));
    }

    Nodes.Node stash(Nodes.Node node, String name) {
        YARPExecutedOnceExpression e = new YARPExecutedOnceExpression(name, node, this.yarpTranslator);
        RubyNode writeNode = e.getWriteNode();
        if (writeNode != null) {
            this.prolog.add(writeNode);
        }
        return e.getReadYARPNode();
    }
}

