/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import java.util.Objects;
import org.prism.Nodes;
import org.truffleruby.core.array.MultipleAssignmentNode;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.CheckNoKeywordArgumentsNode;
import org.truffleruby.language.arguments.MissingArgumentBehavior;
import org.truffleruby.language.arguments.ReadKeywordArgumentNode;
import org.truffleruby.language.arguments.ReadKeywordRestArgumentNode;
import org.truffleruby.language.arguments.ReadOptionalArgumentNode;
import org.truffleruby.language.arguments.ReadPostArgumentNode;
import org.truffleruby.language.arguments.ReadPreArgumentNode;
import org.truffleruby.language.arguments.ReadRestArgumentNode;
import org.truffleruby.language.arguments.SaveMethodBlockNode;
import org.truffleruby.language.locals.WriteLocalVariableNode;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.parser.TranslatorEnvironment;
import org.truffleruby.parser.YARPBaseTranslator;
import org.truffleruby.parser.YARPMultiTargetNodeTranslator;
import org.truffleruby.parser.YARPTranslator;

public final class YARPLoadArgumentsTranslator
extends YARPBaseTranslator {
    private final Arity arity;
    private final boolean isProc;
    private final boolean isMethod;
    private final YARPTranslator yarpTranslator;
    private final Nodes.ParametersNode parameters;
    private int index = 0;
    private State state;
    private int repeatedParameterCounter = 2;

    public YARPLoadArgumentsTranslator(TranslatorEnvironment environment, Nodes.ParametersNode parameters, Arity arity, boolean isProc, boolean isMethod, YARPTranslator yarpTranslator) {
        super(environment);
        this.arity = arity;
        this.isProc = isProc;
        this.isMethod = isMethod;
        this.yarpTranslator = yarpTranslator;
        this.parameters = Objects.requireNonNull(parameters);
    }

    public RubyNode translate() {
        ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
        sequence.add(YARPTranslator.loadSelf(this.language));
        if (this.parameters.requireds.length > 0) {
            this.state = State.PRE;
            for (Nodes.Node node : this.parameters.requireds) {
                sequence.add(node.accept(this));
                ++this.index;
            }
        }
        if (this.isMethod) {
            sequence.add(this.saveMethodBlockArg());
        }
        if (this.parameters == ZERO_PARAMETERS_NODE) {
            return YARPLoadArgumentsTranslator.sequence(sequence.toArray(RubyNode.EMPTY_ARRAY));
        }
        if (this.parameters.optionals.length > 0) {
            for (Nodes.Node node : this.parameters.optionals) {
                sequence.add(((Nodes.OptionalParameterNode)node).accept(this));
                ++this.index;
            }
        }
        if (this.parameters.rest != null && !(this.parameters.rest instanceof Nodes.ImplicitRestNode)) {
            sequence.add(this.parameters.rest.accept(this));
        }
        if (this.parameters.posts.length > 0) {
            this.state = State.POST;
            this.index = -1;
            for (int i = this.parameters.posts.length - 1; i >= 0; --i) {
                sequence.add(this.parameters.posts[i].accept(this));
                --this.index;
            }
        }
        for (Nodes.Node node : this.parameters.keywords) {
            sequence.add(node.accept(this));
        }
        if (this.parameters.keyword_rest != null) {
            sequence.add(this.parameters.keyword_rest.accept(this));
        }
        if (this.parameters.block != null) {
            sequence.add(this.parameters.block.accept(this));
        }
        return YARPLoadArgumentsTranslator.sequence(sequence.toArray(RubyNode.EMPTY_ARRAY));
    }

    public RubyNode saveMethodBlockArg() {
        int slot = this.environment.declareVar("%method_block_arg");
        return new SaveMethodBlockNode(slot);
    }

    @Override
    public RubyNode visitMultiTargetNode(Nodes.MultiTargetNode node) {
        RubyNode readNode;
        if (this.state == State.PRE) {
            readNode = YARPTranslator.profileArgument(this.language, new ReadPreArgumentNode(this.index, this.hasKeywordArguments(), this.isProc ? MissingArgumentBehavior.NIL : MissingArgumentBehavior.RUNTIME_ERROR));
        } else if (this.state == State.POST) {
            readNode = new ReadPostArgumentNode(-this.index, this.getRequiredCount(), this.getOptionalCount(), this.hasRest(), this.hasKeywordArguments());
        } else {
            throw CompilerDirectives.shouldNotReachHere();
        }
        YARPMultiTargetNodeTranslator translator = new YARPMultiTargetNodeTranslator(node, this.language, this.yarpTranslator, readNode);
        MultipleAssignmentNode rubyNode = translator.translate();
        assert (translator.prolog.isEmpty());
        return rubyNode;
    }

    @Override
    public RubyNode visitRequiredKeywordParameterNode(Nodes.RequiredKeywordParameterNode node) {
        int slot = this.environment.findFrameSlot(node.name);
        RubySymbol name = this.language.getSymbol(node.name);
        ReadKeywordArgumentNode readNode = ReadKeywordArgumentNode.create(name, null);
        return new WriteLocalVariableNode(slot, readNode);
    }

    @Override
    public RubyNode visitRequiredParameterNode(Nodes.RequiredParameterNode node) {
        int slot;
        RubyNode readNode;
        if (this.state == State.PRE) {
            readNode = YARPTranslator.profileArgument(this.language, new ReadPreArgumentNode(this.index, this.hasKeywordArguments(), this.isProc ? MissingArgumentBehavior.NIL : MissingArgumentBehavior.RUNTIME_ERROR));
        } else if (this.state == State.POST) {
            readNode = new ReadPostArgumentNode(-this.index, this.getRequiredCount(), this.getOptionalCount(), this.hasRest(), this.hasKeywordArguments());
        } else {
            throw CompilerDirectives.shouldNotReachHere();
        }
        if (node.isRepeatedParameter()) {
            String name = this.createNameForRepeatedParameter(node.name);
            slot = this.environment.declareVar(name);
        } else {
            slot = this.environment.findFrameSlot(node.name);
        }
        return new WriteLocalVariableNode(slot, readNode);
    }

    @Override
    public RubyNode visitOptionalKeywordParameterNode(Nodes.OptionalKeywordParameterNode node) {
        int slot = this.environment.findFrameSlot(node.name);
        RubySymbol name = this.language.getSymbol(node.name);
        RubyNode value = node.value.accept(this);
        ReadKeywordArgumentNode readNode = ReadKeywordArgumentNode.create(name, value);
        return new WriteLocalVariableNode(slot, readNode);
    }

    @Override
    public RubyNode visitOptionalParameterNode(Nodes.OptionalParameterNode node) {
        int slot;
        RubyNode defaultValue = node.value.accept(this);
        int minimum = this.index + 1 + this.parameters.posts.length;
        ReadOptionalArgumentNode readNode = new ReadOptionalArgumentNode(this.index, minimum, this.hasKeywordArguments(), defaultValue);
        if (node.isRepeatedParameter()) {
            String name = this.createNameForRepeatedParameter(node.name);
            slot = this.environment.declareVar(name);
        } else {
            slot = this.environment.findFrameSlot(node.name);
        }
        return new WriteLocalVariableNode(slot, readNode);
    }

    @Override
    public RubyNode visitRestParameterNode(Nodes.RestParameterNode node) {
        int slot;
        int from = this.parameters.requireds.length + this.parameters.optionals.length;
        int to = -this.parameters.posts.length;
        ReadRestArgumentNode readNode = new ReadRestArgumentNode(from, -to, this.hasKeywordArguments());
        if (node.name != null) {
            if (node.isRepeatedParameter()) {
                String name = this.createNameForRepeatedParameter(node.name);
                slot = this.environment.declareVar(name);
            } else {
                slot = this.environment.findFrameSlot(node.name);
            }
        } else {
            slot = this.environment.declareVar("%unnamed_rest");
        }
        return new WriteLocalVariableNode(slot, readNode);
    }

    @Override
    public RubyNode visitImplicitRestNode(Nodes.ImplicitRestNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in #translateWithParameters");
    }

    @Override
    public RubyNode visitKeywordRestParameterNode(Nodes.KeywordRestParameterNode node) {
        ReadKeywordRestArgumentNode readNode = new ReadKeywordRestArgumentNode(this.language, this.arity);
        int slot = node.name != null ? this.environment.findFrameSlot(node.name) : this.environment.declareVar("%kwrest");
        return new WriteLocalVariableNode(slot, readNode);
    }

    @Override
    public RubyNode visitNoKeywordsParameterNode(Nodes.NoKeywordsParameterNode node) {
        return new CheckNoKeywordArgumentsNode();
    }

    @Override
    public RubyNode visitBlockParameterNode(Nodes.BlockParameterNode node) {
        int slot = node.name != null ? this.environment.findFrameSlot(node.name) : this.environment.declareVar("%forward_block");
        return new SaveMethodBlockNode(slot);
    }

    @Override
    public RubyNode visitForwardingParameterNode(Nodes.ForwardingParameterNode node) {
        this.environment.declareVar("%forward_rest");
        this.environment.declareVar("%forward_kwrest");
        this.environment.declareVar("%forward_block");
        Nodes.RestParameterNode rest = new Nodes.RestParameterNode(0, "%forward_rest", 0, 0);
        Nodes.KeywordRestParameterNode keyrest = new Nodes.KeywordRestParameterNode(0, "%forward_kwrest", 0, 0);
        Nodes.BlockParameterNode block = new Nodes.BlockParameterNode(0, "%forward_block", 0, 0);
        return YARPLoadArgumentsTranslator.sequence(rest.accept(this), keyrest.accept(this), block.accept(this));
    }

    @Override
    protected RubyNode defaultVisit(Nodes.Node node) {
        return node.accept(this.yarpTranslator);
    }

    private int getRequiredCount() {
        return this.parameters.requireds.length + this.parameters.posts.length;
    }

    private int getOptionalCount() {
        return this.parameters.optionals.length;
    }

    private boolean hasKeywordArguments() {
        return this.parameters.keywords.length != 0 || this.parameters.keyword_rest != null;
    }

    private boolean hasRest() {
        return this.parameters.rest != null;
    }

    private String createNameForRepeatedParameter(String name) {
        int count = this.repeatedParameterCounter++;
        return "%" + name + count;
    }

    private static enum State {
        PRE,
        OPT,
        POST;

    }
}

