/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import org.prism.Nodes;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.locals.LocalVariableType;
import org.truffleruby.language.locals.ReadLocalVariableNode;
import org.truffleruby.language.locals.WriteLocalVariableNode;
import org.truffleruby.language.objects.SelfNode;
import org.truffleruby.parser.TranslatorEnvironment;
import org.truffleruby.parser.YARPTranslator;

public final class YARPExecutedOnceExpression {
    final String name;
    final int slot;
    final Nodes.Node node;
    final RubyNode valueNode;
    final YARPTranslator yarpTranslator;

    public YARPExecutedOnceExpression(String baseName, Nodes.Node node, YARPTranslator yarpTranslator) {
        this.node = node;
        this.yarpTranslator = yarpTranslator;
        if (node instanceof Nodes.SelfNode) {
            this.name = null;
            this.slot = -1;
            this.valueNode = null;
        } else if (node instanceof Nodes.SplatNode) {
            Nodes.SplatNode splatNode = (Nodes.SplatNode)node;
            TranslatorEnvironment environment = yarpTranslator.getEnvironment();
            this.name = environment.allocateLocalTemp(baseName);
            this.slot = environment.declareVar(this.name);
            this.valueNode = splatNode.expression.accept(yarpTranslator);
        } else {
            TranslatorEnvironment environment = yarpTranslator.getEnvironment();
            this.name = environment.allocateLocalTemp(baseName);
            this.slot = environment.declareVar(this.name);
            this.valueNode = node.accept(yarpTranslator);
        }
    }

    public Nodes.Node getReadYARPNode() {
        if (this.node instanceof Nodes.SelfNode) {
            return this.node;
        }
        if (this.node instanceof Nodes.SplatNode) {
            Nodes.LocalVariableReadNode read = new Nodes.LocalVariableReadNode(this.name, 0, 0, 0);
            return new Nodes.SplatNode(read, this.node.startOffset, this.node.length);
        }
        return new Nodes.LocalVariableReadNode(this.name, 0, this.node.startOffset, this.node.length);
    }

    public RubyNode getReadNode() {
        if (this.node instanceof Nodes.SelfNode) {
            return new SelfNode();
        }
        if (this.node instanceof Nodes.SplatNode) {
            return this.getReadYARPNode().accept(this.yarpTranslator);
        }
        return new ReadLocalVariableNode(LocalVariableType.FRAME_LOCAL, this.slot);
    }

    public RubyNode getWriteNode() {
        if (this.node instanceof Nodes.SelfNode) {
            return null;
        }
        return new WriteLocalVariableNode(this.slot, this.valueNode);
    }
}

