/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.SourceSection;
import java.util.function.Supplier;
import org.prism.Nodes;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Split;
import org.truffleruby.core.IsNilNode;
import org.truffleruby.core.cast.SplatCastNode;
import org.truffleruby.core.cast.SplatCastNodeGen;
import org.truffleruby.core.proc.ProcCallTargets;
import org.truffleruby.core.proc.ProcType;
import org.truffleruby.language.RubyLambdaRootNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyProcRootNode;
import org.truffleruby.language.arguments.MissingArgumentBehavior;
import org.truffleruby.language.arguments.ReadPreArgumentNode;
import org.truffleruby.language.arguments.ShouldDestructureNode;
import org.truffleruby.language.control.AndNode;
import org.truffleruby.language.control.AndNodeGen;
import org.truffleruby.language.control.DynamicReturnNode;
import org.truffleruby.language.control.IfElseNodeGen;
import org.truffleruby.language.control.InvalidReturnNode;
import org.truffleruby.language.control.NotNodeGen;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.language.locals.LocalVariableType;
import org.truffleruby.language.locals.ReadLocalVariableNode;
import org.truffleruby.language.locals.WriteLocalVariableNode;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.BlockDefinitionNode;
import org.truffleruby.language.methods.BlockDefinitionNodeGen;
import org.truffleruby.parser.TranslatorEnvironment;
import org.truffleruby.parser.YARPLoadArgumentsTranslator;
import org.truffleruby.parser.YARPParametersNodeToDestructureTranslator;
import org.truffleruby.parser.YARPTranslator;

public final class YARPBlockNodeTranslator
extends YARPTranslator {
    private final Arity arity;

    public YARPBlockNodeTranslator(TranslatorEnvironment environment, Arity arity) {
        super(environment);
        this.arity = arity;
    }

    public RubyNode compileBlockNode(Nodes.Node body, Nodes.ParametersNode parameters, String[] locals, boolean isStabbyLambda, SourceSection sourceSection) {
        ProcCallTargets callTargets;
        this.declareLocalVariables(locals);
        RubyNode loadArguments = new YARPLoadArgumentsTranslator(this.environment, parameters, this.arity, !isStabbyLambda, false, this).translate();
        RubyNode preludeProc = !isStabbyLambda ? this.preludeProc(this.arity, loadArguments, parameters) : null;
        RubyNode bodyNode = this.translateNodeOrNil(body).simplifyAsTailExpression();
        boolean isLambdaMethodCall = !isStabbyLambda && this.environment.literalBlockPassedToMethod.equals("lambda");
        boolean emitLambda = isStabbyLambda || isLambdaMethodCall;
        Supplier<RootCallTarget> procCompiler = YARPBlockNodeTranslator.procCompiler(this.arity, preludeProc, bodyNode, isLambdaMethodCall, this.language, this.environment, sourceSection);
        Supplier<RootCallTarget> lambdaCompiler = YARPBlockNodeTranslator.lambdaCompiler(isStabbyLambda, this.arity, loadArguments, bodyNode, emitLambda, this.language, this.environment, sourceSection);
        int frameOnStackMarkerSlot = emitLambda || this.frameOnStackMarkerSlotStack.isEmpty() ? -1 : (Integer)this.frameOnStackMarkerSlotStack.peek();
        if (isStabbyLambda) {
            RootCallTarget callTarget = lambdaCompiler.get();
            callTargets = new ProcCallTargets(callTarget);
        } else {
            callTargets = isLambdaMethodCall ? new ProcCallTargets(null, lambdaCompiler.get(), procCompiler) : new ProcCallTargets(procCompiler.get(), null, lambdaCompiler);
        }
        BlockDefinitionNode rubyNode = BlockDefinitionNodeGen.create(emitLambda ? ProcType.LAMBDA : ProcType.PROC, this.environment.getSharedMethodInfo(), callTargets, this.environment.getBreakID(), frameOnStackMarkerSlot);
        return rubyNode;
    }

    private void declareLocalVariables(String[] locals) {
        for (String name : locals) {
            this.environment.declareVar(name);
        }
    }

    private RubyNode preludeProc(Arity arity, RubyNode loadArguments, Nodes.ParametersNode parameters) {
        RubyNode preludeNode;
        if (this.shouldConsiderDestructuringArrayArg(arity)) {
            RubyNode readFirstArgumentNode = YARPTranslator.profileArgument(this.language, new ReadPreArgumentNode(0, arity.acceptsKeywords(), MissingArgumentBehavior.RUNTIME_ERROR));
            SplatCastNode castArrayNode = SplatCastNodeGen.create(this.language, SplatCastNode.NilBehavior.NIL, true, readFirstArgumentNode);
            castArrayNode.doNotCopy();
            int arraySlot = this.environment.declareLocalTemp("destructure");
            WriteLocalVariableNode writeArrayNode = new WriteLocalVariableNode(arraySlot, castArrayNode);
            ReadLocalVariableNode readArrayNode = new ReadLocalVariableNode(LocalVariableType.FRAME_LOCAL, arraySlot);
            YARPParametersNodeToDestructureTranslator translator = new YARPParametersNodeToDestructureTranslator(this.environment, parameters, readArrayNode, this);
            RubyNode newDestructureArguments = translator.translate();
            RubyNode arrayWasNotNil = YARPTranslator.sequence(writeArrayNode, NotNodeGen.create(new IsNilNode(readArrayNode)));
            AndNode shouldDestructureAndArrayWasNotNil = AndNodeGen.create(new ShouldDestructureNode(arity.acceptsKeywords()), arrayWasNotNil);
            preludeNode = IfElseNodeGen.create(shouldDestructureAndArrayWasNotNil, newDestructureArguments, loadArguments);
        } else {
            preludeNode = loadArguments;
        }
        return preludeNode;
    }

    private static Supplier<RootCallTarget> procCompiler(Arity arityForCheck, RubyNode preludeProc, RubyNode body, boolean isLambdaMethodCall, RubyLanguage language, TranslatorEnvironment environment, SourceSection sourceSection) {
        return () -> {
            RubyNode bodyForProc = isLambdaMethodCall ? body.cloneUninitialized() : body;
            RubyNode bodyProc = YARPBlockNodeTranslator.composeBody(environment, preludeProc, bodyForProc);
            RubyProcRootNode newRootNodeForProcs = new RubyProcRootNode(language, sourceSection, environment.computeFrameDescriptor(), environment.getSharedMethodInfo(), bodyProc, Split.HEURISTIC, environment.getReturnID(), arityForCheck);
            RootCallTarget callTarget = newRootNodeForProcs.getCallTarget();
            if (isLambdaMethodCall) {
                for (DynamicReturnNode returnNode : NodeUtil.findAllNodeInstances((Node)bodyForProc, DynamicReturnNode.class)) {
                    if (returnNode.returnID != ReturnID.MODULE_BODY) continue;
                    returnNode.replace(new InvalidReturnNode(returnNode.value));
                }
            }
            return callTarget;
        };
    }

    private static Supplier<RootCallTarget> lambdaCompiler(boolean isStabbyLambda, Arity arityForCheck, RubyNode loadArguments, RubyNode body, boolean emitLambda, RubyLanguage language, TranslatorEnvironment environment, SourceSection sourceSection) {
        return () -> {
            RubyNode bodyForLambda = emitLambda ? body : body.cloneUninitialized();
            RubyNode preludeLambda = isStabbyLambda ? loadArguments : loadArguments.cloneUninitialized();
            RubyNode bodyLambda = YARPBlockNodeTranslator.composeBody(environment, preludeLambda, bodyForLambda);
            RubyLambdaRootNode newRootNodeForLambdas = new RubyLambdaRootNode(language, sourceSection, environment.computeFrameDescriptor(), environment.getSharedMethodInfo(), bodyLambda, Split.HEURISTIC, environment.getReturnID(), environment.getBreakID(), arityForCheck);
            RootCallTarget callTarget = newRootNodeForLambdas.getCallTarget();
            if (!isStabbyLambda) {
                for (InvalidReturnNode returnNode : NodeUtil.findAllNodeInstances((Node)bodyForLambda, InvalidReturnNode.class)) {
                    returnNode.replace(new DynamicReturnNode(environment.getReturnID(), returnNode.value));
                }
            }
            return callTarget;
        };
    }

    private static RubyNode composeBody(TranslatorEnvironment environment, RubyNode prelude, RubyNode body) {
        body = YARPTranslator.sequence(prelude, body);
        if (environment.getFlipFlopStates().size() > 0) {
            body = YARPTranslator.sequence(YARPTranslator.initFlipFlopStates(environment), body);
        }
        return body;
    }

    private boolean shouldConsiderDestructuringArrayArg(Arity arity) {
        if (!arity.hasRest() && arity.getRequired() + arity.getOptional() <= 1) {
            return false;
        }
        return !arity.hasRest() || arity.getRequired() != 0;
    }
}

