/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import org.truffleruby.language.threadlocal.SpecialVariableStorage;

public final class BlockDescriptorInfo {
    @CompilerDirectives.CompilationFinal
    private FrameDescriptor parentDescriptor;
    private final Assumption specialVariableAssumption;

    @ExplodeLoop
    public static FrameDescriptor getDeclarationFrameDescriptor(FrameDescriptor topDescriptor, int depth) {
        assert (depth > 0);
        FrameDescriptor descriptor = topDescriptor;
        for (int i = 0; i < depth; ++i) {
            descriptor = ((BlockDescriptorInfo)descriptor.getInfo()).getParentDescriptor();
        }
        return descriptor;
    }

    public BlockDescriptorInfo(Assumption specialVariableAssumption) {
        assert (SpecialVariableStorage.isSpecialVariableAssumption(specialVariableAssumption));
        this.specialVariableAssumption = specialVariableAssumption;
    }

    public BlockDescriptorInfo(FrameDescriptor parentDescriptor) {
        this.parentDescriptor = parentDescriptor;
        this.specialVariableAssumption = this.getSpecialVariableAssumptionFromDescriptor(parentDescriptor);
    }

    private Assumption getSpecialVariableAssumptionFromDescriptor(FrameDescriptor descriptor) {
        Object object = descriptor.getInfo();
        if (object instanceof BlockDescriptorInfo) {
            BlockDescriptorInfo blockDescriptorInfo = (BlockDescriptorInfo)object;
            return blockDescriptorInfo.getSpecialVariableAssumption();
        }
        return SpecialVariableStorage.getAssumption(descriptor);
    }

    public FrameDescriptor getParentDescriptor() {
        assert (this.parentDescriptor != null);
        return this.parentDescriptor;
    }

    void setParentDescriptor(FrameDescriptor parentDescriptor) {
        assert (this.parentDescriptor == null);
        this.parentDescriptor = parentDescriptor;
    }

    public Assumption getSpecialVariableAssumption() {
        assert (this.specialVariableAssumption != null);
        return this.specialVariableAssumption;
    }
}

