/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.threadlocal;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.interop.TranslateInteropExceptionNode;
import org.truffleruby.language.Nil;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.threadlocal.ThreadAndFrameLocalStorage;

@ExportLibrary(value=InteropLibrary.class)
public final class SpecialVariableStorage
implements TruffleObject {
    public static final int SLOT_INDEX = 1;
    public static final String SLOT_NAME = "%$~_";
    public static final String ASSUMPTION_NAME = "does not need SpecialVariableStorage";
    private ThreadAndFrameLocalStorage lastMatch;
    private ThreadAndFrameLocalStorage lastLine;

    public static Object get(Frame frame) {
        assert (SpecialVariableStorage.hasSpecialVariableStorageSlot(frame));
        return frame.getObject(1);
    }

    public static void set(Frame frame, SpecialVariableStorage variables) {
        assert (SpecialVariableStorage.hasSpecialVariableStorageSlot(frame));
        frame.setObject(1, (Object)variables);
    }

    public static Assumption getAssumption(FrameDescriptor descriptor) {
        assert (SpecialVariableStorage.hasSpecialVariableStorageSlot(descriptor));
        return (Assumption)descriptor.getInfo();
    }

    public static boolean isSpecialVariableAssumption(Assumption assumption) {
        return assumption.getName() == ASSUMPTION_NAME;
    }

    public static boolean hasSpecialVariableAssumption(FrameDescriptor descriptor) {
        Assumption assumption;
        Object info = descriptor.getInfo();
        return info instanceof Assumption && SpecialVariableStorage.isSpecialVariableAssumption(assumption = (Assumption)info);
    }

    public static boolean hasSpecialVariableStorageSlot(Frame frame) {
        assert (RubyArguments.getDeclarationFrame(frame) == null);
        return SpecialVariableStorage.hasSpecialVariableStorageSlot(frame.getFrameDescriptor());
    }

    private static boolean hasSpecialVariableStorageSlot(FrameDescriptor descriptor) {
        assert (1 < descriptor.getNumberOfSlots());
        assert (descriptor.getSlotName(1) == SLOT_NAME);
        Assumption assumption = (Assumption)descriptor.getInfo();
        return SpecialVariableStorage.isSpecialVariableAssumption(assumption);
    }

    public Object getLastMatch(Node node, InlinedConditionProfile unsetProfile, InlinedConditionProfile sameThreadProfile) {
        if (unsetProfile.profile(node, this.lastMatch == null)) {
            return Nil.INSTANCE;
        }
        return this.lastMatch.get(node, sameThreadProfile);
    }

    public void setLastMatch(Node node, Object value, RubyContext context, InlinedConditionProfile unsetProfile, InlinedConditionProfile sameThreadProfile) {
        if (unsetProfile.profile(node, this.lastMatch == null)) {
            this.lastMatch = new ThreadAndFrameLocalStorage(context);
        }
        this.lastMatch.set(node, value, sameThreadProfile);
    }

    public Object getLastLine(Node node, InlinedConditionProfile unsetProfile, InlinedConditionProfile sameThreadProfilew) {
        if (unsetProfile.profile(node, this.lastLine == null)) {
            return Nil.INSTANCE;
        }
        return this.lastLine.get(node, sameThreadProfilew);
    }

    public void setLastLine(Node node, Object value, RubyContext context, InlinedConditionProfile unsetProfile, InlinedConditionProfile sameThreadProfile) {
        if (unsetProfile.profile(node, this.lastLine == null)) {
            this.lastLine = new ThreadAndFrameLocalStorage(context);
        }
        this.lastLine.set(node, value, sameThreadProfile);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    protected String toDisplayString(boolean allowSideEffects) {
        InteropLibrary interop = InteropLibrary.getUncached();
        InlinedConditionProfile profile = InlinedConditionProfile.getUncached();
        Object result = "SpecialVariableStorage($~: ";
        if (this.lastMatch != null) {
            try {
                result = (String)result + interop.asString(interop.toDisplayString(this.lastMatch.get(null, profile), allowSideEffects));
            }
            catch (UnsupportedMessageException e) {
                throw TranslateInteropExceptionNode.executeUncached((InteropException)((Object)e));
            }
        } else {
            result = (String)result + "nil";
        }
        result = (String)result + ", $_: ";
        if (this.lastLine != null) {
            try {
                result = (String)result + interop.asString(interop.toDisplayString(this.lastLine.get(null, profile), allowSideEffects));
            }
            catch (UnsupportedMessageException e) {
                throw TranslateInteropExceptionNode.executeUncached((InteropException)((Object)e));
            }
        } else {
            result = (String)result + "nil";
        }
        return (String)result + ")";
    }

    public String toString() {
        return this.toDisplayString(false);
    }
}

