/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.supercall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.MethodLookupResult;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.objects.MetaClassNode;

public abstract class LookupSuperMethodNode
extends RubyBaseNode {
    public abstract InternalMethod executeLookupSuperMethod(VirtualFrame var1, Object var2);

    @Specialization(guards={"isSingleContext()", "getCurrentMethod(frame) == currentMethod", "metaClassNode.execute(this, self) == selfMetaClass"}, assumptions={"superMethod.getAssumptions()"}, limit="getCacheLimit()")
    InternalMethod lookupSuperMethodCached(VirtualFrame frame, Object self, @Cached(value="getCurrentMethod(frame)") InternalMethod currentMethod, @Cached @Cached.Shared MetaClassNode metaClassNode, @Cached(value="metaClassNode.execute(this, self)") RubyClass selfMetaClass, @Cached(value="doLookup(currentMethod, selfMetaClass)") MethodLookupResult superMethod) {
        return superMethod.getMethod();
    }

    @Specialization
    InternalMethod lookupSuperMethodUncached(VirtualFrame frame, Object self, @Cached @Cached.Shared MetaClassNode metaClassNode) {
        InternalMethod currentMethod = this.getCurrentMethod(frame);
        RubyClass selfMetaClass = metaClassNode.execute(this, self);
        return this.doLookup(currentMethod, selfMetaClass).getMethod();
    }

    protected InternalMethod getCurrentMethod(VirtualFrame frame) {
        return RubyArguments.getMethod((Frame)frame);
    }

    @CompilerDirectives.TruffleBoundary
    protected MethodLookupResult doLookup(InternalMethod currentMethod, RubyClass selfMetaClass) {
        MethodLookupResult superMethod = ModuleOperations.lookupSuperMethod(currentMethod, selfMetaClass);
        if (!superMethod.isDefined()) {
            return superMethod.withNoMethod();
        }
        return superMethod;
    }

    protected int getCacheLimit() {
        return this.getLanguage().options.METHOD_LOOKUP_CACHE;
    }
}

