/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects.shared;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.array.library.SharedArrayStorage;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.language.ImmutableRubyObject;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ShapeCachingGuards;
import org.truffleruby.language.objects.classvariables.ClassVariableStorage;

public final class SharedObjects {
    private final RubyContext context;
    private boolean sharing = false;

    public SharedObjects(RubyContext context) {
        this.context = context;
    }

    public boolean isSharing() {
        return this.sharing;
    }

    public void startSharing(RubyLanguage language, String reason) {
        if (!this.sharing) {
            this.sharing = true;
            if (language.options.SHARED_OBJECTS_DEBUG) {
                RubyLanguage.LOGGER.info("starting sharing due to " + reason);
            }
            SharedObjects.shareContextRoots(language, this.context);
        }
    }

    private static void shareContextRoots(RubyLanguage language, RubyContext context) {
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        for (Object object : context.getCoreLibrary().globalVariables.objectGraphValues()) {
            stack.push(object);
        }
        for (Object object : context.getNativeConfiguration().objectGraphValues()) {
            stack.push(object);
        }
        stack.push(context.getCoreLibrary().objectClass);
        for (RubyThread thread : context.getThreadManager().iterateThreads()) {
            stack.push(thread);
        }
        long t0 = System.currentTimeMillis();
        SharedObjects.shareObjects(stack);
        if (language.options.SHARED_OBJECTS_DEBUG) {
            RubyLanguage.LOGGER.info("sharing roots took " + (System.currentTimeMillis() - t0) + " ms");
        }
    }

    public static void shareBlockAndArguments(RubyLanguage language, RubyProc block, Object[] args, String info) {
        if (language.options.SHARED_OBJECTS_DEBUG) {
            RubyLanguage.LOGGER.info("sharing block and arguments of " + info);
        }
        Set<Object> objects = ObjectGraph.newObjectSet();
        ObjectGraph.getObjectsInFrame((Frame)block.declarationFrame, objects);
        ObjectGraph.addProperty(objects, args);
        ArrayDeque<Object> stack = new ArrayDeque<Object>(objects);
        SharedObjects.shareObjects(stack);
    }

    private static void shareObjects(Deque<Object> stack) {
        while (!stack.isEmpty()) {
            Object object = stack.pop();
            assert (ObjectGraph.isRubyObject(object)) : object;
            if (!(object instanceof RubyDynamicObject) || !SharedObjects.share((RubyDynamicObject)((Object)object))) continue;
            stack.addAll(ObjectGraph.getAdjacentObjects((RubyDynamicObject)((Object)object)));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void shareObject(RubyDynamicObject value) {
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.add((Object)value);
        SharedObjects.shareObjects(stack);
    }

    public static boolean isShared(Object object) {
        return object instanceof ImmutableRubyObject || object instanceof RubyDynamicObject && SharedObjects.isShared((RubyDynamicObject)((Object)object));
    }

    public static boolean isShared(RubyDynamicObject object) {
        return object.getShape().isShared();
    }

    public static boolean assertPropagateSharing(RubyDynamicObject source, Object value) {
        if (SharedObjects.isShared(source) && value instanceof RubyDynamicObject) {
            return SharedObjects.isShared(value);
        }
        return true;
    }

    public static void writeBarrier(RubyLanguage language, Object value) {
        if (language.options.SHARED_OBJECTS_ENABLED && value instanceof RubyDynamicObject && !SharedObjects.isShared(value)) {
            SharedObjects.shareObject((RubyDynamicObject)((Object)value));
            assert (!(value instanceof RubyArray) || SharedObjects.validateArray((RubyArray)value));
        }
    }

    private static boolean validateArray(RubyArray value) {
        Object storage = value.getStore();
        assert (storage instanceof SharedArrayStorage);
        return ((SharedArrayStorage)storage).allElementsShared(value.size);
    }

    public static void propagate(RubyLanguage language, RubyDynamicObject source, Object value) {
        if (SharedObjects.isShared(source)) {
            SharedObjects.writeBarrier(language, value);
        }
    }

    private static boolean share(RubyDynamicObject object) {
        if (SharedObjects.isShared(object)) {
            return false;
        }
        ShapeCachingGuards.updateShape(object);
        DynamicObjectLibrary.getUncached().markShared((DynamicObject)object);
        SharedObjects.onShareHook(object);
        return true;
    }

    public static void onShareHook(RubyDynamicObject object) {
        if (object instanceof RubyModule) {
            ClassVariableStorage classVariables = ((RubyModule)object).fields.getClassVariables();
            DynamicObjectLibrary.getUncached().updateShape((DynamicObject)classVariables);
            DynamicObjectLibrary.getUncached().markShared((DynamicObject)classVariables);
        } else if (object instanceof RubyArray) {
            RubyArray array = (RubyArray)object;
            array.setStore(ArrayStoreLibrary.getUncached().makeShared(array.getStore(), array.size));
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void shareInternalFields(RubyDynamicObject object) {
        SharedObjects.onShareHook(object);
        ArrayDeque<Object> stack = new ArrayDeque<Object>(ObjectGraph.getAdjacentObjects(object));
        SharedObjects.shareObjects(stack);
    }
}

