/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects.classvariables;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.objects.classvariables.LookupClassVariableNode;
import org.truffleruby.language.objects.classvariables.ResolveTargetModuleForClassVariablesNode;

public final class ReadClassVariableNode
extends RubyContextSourceNode {
    private final String name;
    private final BranchProfile missingProfile = BranchProfile.create();
    private final BranchProfile topLevelProfile = BranchProfile.create();
    @Node.Child
    private RubyNode lexicalScopeNode;
    @Node.Child
    private ResolveTargetModuleForClassVariablesNode resolveTargetModuleNode = ResolveTargetModuleForClassVariablesNode.create();
    @Node.Child
    private LookupClassVariableNode lookupClassVariableNode = LookupClassVariableNode.create();

    public ReadClassVariableNode(RubyNode lexicalScopeNode, String name) {
        this.lexicalScopeNode = lexicalScopeNode;
        this.name = name;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        LexicalScope lexicalScope = (LexicalScope)this.lexicalScopeNode.execute(frame);
        if (lexicalScope.getParent() == null) {
            this.topLevelProfile.enter();
            throw new RaiseException(this.getContext(), this.coreExceptions().runtimeErrorClassVariableTopLevel(this));
        }
        RubyModule module = this.resolveTargetModuleNode.execute(lexicalScope);
        Object value = this.lookupClassVariableNode.execute(module, this.name);
        if (value == null) {
            this.missingProfile.enter();
            throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().nameErrorUninitializedClassVariable(module, this.name, this));
        }
        return value;
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        LexicalScope lexicalScope = (LexicalScope)this.lexicalScopeNode.execute(frame);
        RubyModule module = this.resolveTargetModuleNode.execute(lexicalScope);
        Object value = this.lookupClassVariableNode.execute(module, this.name);
        if (value == null) {
            return nil;
        }
        return FrozenStrings.CLASS_VARIABLE;
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadClassVariableNode copy = new ReadClassVariableNode(this.lexicalScopeNode.cloneUninitialized(), this.name);
        return copy.copyFlags(this);
    }
}

