/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects.classvariables;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.objects.classvariables.ClassVariableStorage;

@GenerateCached(value=false)
@GenerateInline
@ReportPolymorphism
public abstract class LookupClassVariableStorageNode
extends RubyBaseNode {
    public abstract ClassVariableStorage execute(Node var1, RubyModule var2, String var3);

    @Specialization(guards={"objectLibrary.containsKey(classVariableStorage, name)"})
    static ClassVariableStorage lookupClassVariable(RubyModule module, String name, @Bind(value="module.fields.getClassVariables()") ClassVariableStorage classVariableStorage, @CachedLibrary(limit="getDynamicObjectCacheLimit()") DynamicObjectLibrary objectLibrary) {
        return classVariableStorage;
    }

    @Specialization(replaces={"lookupClassVariable"})
    @CompilerDirectives.TruffleBoundary
    static ClassVariableStorage uncachedLookupClassVariable(RubyModule module, String name) {
        return ModuleOperations.classVariableLookup(module, true, m -> {
            ClassVariableStorage classVariables = m.fields.getClassVariables();
            if (classVariables.getShape().hasProperty((Object)name)) {
                return classVariables;
            }
            return null;
        });
    }
}

