/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.locals.ReadFrameSlotNode;
import org.truffleruby.language.locals.ReadFrameSlotNodeGen;

public final class SelfNode
extends RubyContextSourceNode {
    public static final int SELF_INDEX = 0;
    public static final HiddenKey SELF_IDENTIFIER = new HiddenKey("(self)");
    @Node.Child
    private ReadFrameSlotNode readSelfSlotNode;

    public static ReadFrameSlotNode createReadSelfFrameSlotNode() {
        return ReadFrameSlotNodeGen.create(0);
    }

    public static Object readSelf(VirtualFrame frame, ReadFrameSlotNode readSelfSlotNode) {
        assert (frame.getFrameDescriptor().getSlotName(0) == SELF_IDENTIFIER);
        return readSelfSlotNode.executeRead((Frame)frame);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (this.readSelfSlotNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.readSelfSlotNode = (ReadFrameSlotNode)this.insert(SelfNode.createReadSelfFrameSlotNode());
        }
        return SelfNode.readSelf(frame, this.readSelfSlotNode);
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        return FrozenStrings.SELF;
    }

    @Override
    public RubyNode cloneUninitialized() {
        SelfNode copy = new SelfNode();
        return copy.copyFlags(this);
    }
}

