/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import java.math.BigInteger;
import org.truffleruby.core.numeric.BignumOperations;
import org.truffleruby.core.numeric.RubyBignum;

public abstract class ObjectIDOperations {
    public static final long FALSE = 0L;
    public static final long TRUE = 6L;
    public static final long NIL = 2L;
    private static final BigInteger LARGE_FIXNUM_FLAG = BigInteger.ONE.shiftLeft(64);
    private static final BigInteger FLOAT_FLAG = BigInteger.ONE.shiftLeft(65);
    private static final long TWO_AS_LONG = 2L;

    public static boolean isSmallFixnum(long fixnum) {
        return -4611686018427387904L <= fixnum && fixnum <= 0x3FFFFFFFFFFFFFFFL;
    }

    public static long smallFixnumToIDOverflow(long fixnum) throws ArithmeticException {
        return Math.addExact(Math.multiplyExact(fixnum, 2L), 1L);
    }

    public static long smallFixnumToID(long fixnum) {
        assert (ObjectIDOperations.isSmallFixnum(fixnum));
        return fixnum * 2L + 1L;
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyBignum largeFixnumToID(long fixnum) {
        assert (!ObjectIDOperations.isSmallFixnum(fixnum));
        BigInteger big = ObjectIDOperations.unsignedBigInteger(fixnum);
        return BignumOperations.createBignum(big.or(LARGE_FIXNUM_FLAG));
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyBignum floatToID(double value) {
        long bits = Double.doubleToRawLongBits(value);
        BigInteger big = ObjectIDOperations.unsignedBigInteger(bits);
        return BignumOperations.createBignum(big.or(FLOAT_FLAG));
    }

    public static boolean isSmallFixnumID(long id) {
        return id % 2L != 0L;
    }

    public static long toFixnum(long id) {
        return (id - 1L) / 2L;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isLargeFixnumID(BigInteger id) {
        return !id.and(LARGE_FIXNUM_FLAG).equals(BigInteger.ZERO);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isFloatID(BigInteger id) {
        return !id.and(FLOAT_FLAG).equals(BigInteger.ZERO);
    }

    public static boolean isBasicObjectID(long id) {
        return id != 0L && (id & 3L) == 0L;
    }

    @CompilerDirectives.TruffleBoundary
    private static BigInteger unsignedBigInteger(long value) {
        BigInteger big = BigInteger.valueOf(value);
        if (value < 0L) {
            big = new BigInteger(1, big.toByteArray());
        }
        return big;
    }
}

