/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.NoImplicitCastsToLong;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.objects.ForeignClassNode;
import org.truffleruby.language.objects.ImmutableClassNode;
import org.truffleruby.language.objects.LogicalClassNodeGen;

@GenerateUncached
@TypeSystemReference(value=NoImplicitCastsToLong.class)
public abstract class LogicalClassNode
extends RubyBaseNode {
    @NeverDefault
    public static LogicalClassNode create() {
        return LogicalClassNodeGen.create();
    }

    public static LogicalClassNode getUncached() {
        return LogicalClassNodeGen.getUncached();
    }

    public abstract RubyClass execute(Object var1);

    @Specialization
    RubyClass logicalClassObject(RubyDynamicObject object) {
        return object.getLogicalClass();
    }

    @Specialization(guards={"isPrimitiveOrImmutable(value)"})
    RubyClass logicalClassImmutable(Object value, @Cached ImmutableClassNode immutableClassNode) {
        return immutableClassNode.execute(this, value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isForeignObject(object)"})
    RubyClass logicalClassForeign(Object object, @Cached ForeignClassNode foreignClassNode) {
        return foreignClassNode.execute(this, object);
    }

    protected int getCacheLimit() {
        return this.getLanguage().options.CLASS_CACHE;
    }
}

