/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.klass.ClassNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.ModuleNodes;
import org.truffleruby.core.module.ModuleNodesFactory;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.dispatch.DispatchNode;

public abstract class InitializeClassNode
extends RubyBaseNode {
    @Node.Child
    private ModuleNodes.InitializeNode moduleInitializeNode;
    @Node.Child
    private DispatchNode inheritedNode;

    public abstract RubyClass executeInitialize(RubyClass var1, RubyClass var2, boolean var3, Object var4);

    @Specialization
    RubyClass initialize(RubyClass rubyClass, RubyClass superclass, boolean callInherited, Nil block) {
        return this.initializeGeneralWithoutBlock(rubyClass, superclass, callInherited);
    }

    @Specialization
    RubyClass initialize(RubyClass rubyClass, RubyClass superclass, boolean callInherited, RubyProc block) {
        return this.initializeGeneralWithBlock(rubyClass, superclass, block, callInherited);
    }

    private RubyClass initializeGeneralWithoutBlock(RubyClass rubyClass, RubyClass superclass, boolean callInherited) {
        this.initializeCommon(rubyClass);
        if (callInherited) {
            this.triggerInheritedHook(rubyClass, superclass);
        }
        return rubyClass;
    }

    private RubyClass initializeGeneralWithBlock(RubyClass rubyClass, RubyClass superclass, RubyProc block, boolean callInherited) {
        this.initializeCommon(rubyClass);
        if (callInherited) {
            this.triggerInheritedHook(rubyClass, superclass);
        }
        this.moduleInitialize(rubyClass, block);
        return rubyClass;
    }

    private void initializeCommon(RubyClass rubyClass) {
        ClassNodes.initialize(this.getContext(), rubyClass);
    }

    private void triggerInheritedHook(RubyClass subClass, RubyClass superClass) {
        if (this.inheritedNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.inheritedNode = (DispatchNode)this.insert(DispatchNode.create());
        }
        this.inheritedNode.call((Object)superClass, "inherited", subClass);
    }

    private void moduleInitialize(RubyClass rubyClass, RubyProc block) {
        if (this.moduleInitializeNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.moduleInitializeNode = (ModuleNodes.InitializeNode)this.insert(ModuleNodesFactory.InitializeNodeFactory.create(null));
        }
        this.moduleInitializeNode.executeInitialize(rubyClass, block);
    }
}

