/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.range.RubyIntOrLongRange;
import org.truffleruby.core.regexp.RubyRegexp;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NoImplicitCastsToLong;
import org.truffleruby.language.RubyBaseNode;

@GenerateInline
@GenerateCached(value=false)
@GenerateUncached
@TypeSystemReference(value=NoImplicitCastsToLong.class)
public abstract class ImmutableClassNode
extends RubyBaseNode {
    public final RubyClass execute(Node node, Object value) {
        return this.execute(node, value, ImmutableClassNode.coreLibrary(node));
    }

    protected abstract RubyClass execute(Node var1, Object var2, CoreLibrary var3);

    @Specialization
    static RubyClass metaClassInt(int value, CoreLibrary coreLibrary) {
        return coreLibrary.integerClass;
    }

    @Specialization
    static RubyClass metaClassImmutableString(ImmutableRubyString value, CoreLibrary coreLibrary) {
        return coreLibrary.stringClass;
    }

    @Specialization
    static RubyClass metaClassSymbol(RubySymbol value, CoreLibrary coreLibrary) {
        return coreLibrary.symbolClass;
    }

    @Specialization
    static RubyClass metaClassNil(Nil value, CoreLibrary coreLibrary) {
        return coreLibrary.nilClass;
    }

    @Specialization(guards={"value"})
    static RubyClass metaClassTrue(boolean value, CoreLibrary coreLibrary) {
        return coreLibrary.trueClass;
    }

    @Specialization(guards={"!value"})
    static RubyClass metaClassFalse(boolean value, CoreLibrary coreLibrary) {
        return coreLibrary.falseClass;
    }

    @Specialization
    static RubyClass metaClassLong(long value, CoreLibrary coreLibrary) {
        return coreLibrary.integerClass;
    }

    @Specialization
    static RubyClass metaClassEncoding(RubyEncoding value, CoreLibrary coreLibrary) {
        return coreLibrary.encodingClass;
    }

    @Specialization
    static RubyClass metaClassRegexp(RubyRegexp value, CoreLibrary coreLibrary) {
        return coreLibrary.regexpClass;
    }

    @Specialization
    static RubyClass metaClassRange(RubyIntOrLongRange value, CoreLibrary coreLibrary) {
        return coreLibrary.rangeClass;
    }

    @Specialization
    static RubyClass metaClassDouble(double value, CoreLibrary coreLibrary) {
        return coreLibrary.floatClass;
    }

    @Specialization
    static RubyClass metaClassBignum(RubyBignum value, CoreLibrary coreLibrary) {
        return coreLibrary.integerClass;
    }
}

