/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.parser.IdentifierType;
import org.truffleruby.parser.Identifiers;

@ImportStatic(value={Identifiers.class})
@GenerateInline
@GenerateCached(value=false)
@ReportPolymorphism
public abstract class CheckIVarNameNode
extends RubyBaseNode {
    public abstract void execute(Node var1, Object var2, String var3, Object var4);

    @Specialization
    static void checkSymbol(Node node, Object object, String name, RubySymbol originalName, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
        if (originalName.getType() != IdentifierType.INSTANCE) {
            errorProfile.enter(node);
            throw new RaiseException(CheckIVarNameNode.getContext(node), (RubyException)CheckIVarNameNode.getContext(node).getCoreExceptions().nameErrorInstanceNameNotAllowable(name, object, node));
        }
    }

    @Specialization(guards={"name == cachedName", "isValidInstanceVariableName(cachedName)", "!isRubySymbol(originalName)"}, limit="getDynamicObjectCacheLimit()")
    static void cached(Object object, String name, Object originalName, @Cached(value="name") String cachedName) {
    }

    @Specialization(replaces={"cached"}, guards={"!isRubySymbol(originalName)"})
    static void uncached(Node node, Object object, String name, Object originalName, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
        if (!Identifiers.isValidInstanceVariableName(name)) {
            errorProfile.enter(node);
            throw new RaiseException(CheckIVarNameNode.getContext(node), (RubyException)CheckIVarNameNode.coreExceptions(node).nameErrorInstanceNameNotAllowable(name, object, node));
        }
    }
}

