/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.RubyContext;
import org.truffleruby.core.VMPrimitiveNodes;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.exception.ExceptionOperations;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.backtrace.BacktraceFormatter;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.control.TerminationException;
import org.truffleruby.language.methods.TranslateExceptionNodeGen;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
public abstract class TranslateExceptionNode
extends RubyBaseNode {
    @NeverDefault
    public static TranslateExceptionNode create() {
        return TranslateExceptionNodeGen.create();
    }

    public abstract RuntimeException execute(Node var1, Throwable var2);

    public final RuntimeException executeCached(Throwable throwable) {
        return this.execute(this, throwable);
    }

    public static void logJavaException(RubyContext context, Node currentNode, Throwable exception) {
        if (context.getOptions().EXCEPTIONS_PRINT_JAVA) {
            TranslateExceptionNode.printStackTrace(exception);
            if (context.getOptions().EXCEPTIONS_PRINT_RUBY_FOR_JAVA) {
                context.getDefaultBacktraceFormatter().printBacktraceOnEnvStderr(currentNode);
            }
        }
    }

    public static void logUncaughtJavaException(RubyContext context, Node currentNode, Throwable exception) {
        if (context.getOptions().EXCEPTIONS_PRINT_JAVA || context.getOptions().EXCEPTIONS_PRINT_UNCAUGHT_JAVA) {
            TranslateExceptionNode.printStackTrace(exception);
            if (context.getOptions().EXCEPTIONS_PRINT_RUBY_FOR_JAVA) {
                context.getDefaultBacktraceFormatter().printBacktraceOnEnvStderr(currentNode);
            }
        }
    }

    @Specialization
    static RuntimeException translate(ControlFlowException e) {
        throw e;
    }

    @Specialization
    static RuntimeException translate(AbstractTruffleException e) {
        throw e;
    }

    @Specialization
    static RuntimeException translate(TerminationException e) {
        throw e;
    }

    @Specialization
    static RuntimeException translate(ThreadDeath e) {
        throw e;
    }

    @Specialization(guards={"needsSpecialTranslation(e)"})
    static RuntimeException translateSpecial(Node node, Throwable e) {
        throw TranslateExceptionNode.doTranslateSpecial(node, e);
    }

    @Fallback
    static RuntimeException translate(Node node, Throwable e) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        TranslateExceptionNode.logUncaughtJavaException(TranslateExceptionNode.getContext(node), node, e);
        throw ExceptionOperations.rethrow(e);
    }

    protected boolean needsSpecialTranslation(Throwable e) {
        return e instanceof TruffleString.IllegalByteArrayLengthException || e instanceof UnsupportedSpecializationException || e instanceof StackOverflowError || e instanceof OutOfMemoryError;
    }

    @CompilerDirectives.TruffleBoundary
    private static RaiseException doTranslateSpecial(Node node, Throwable e) {
        if (e instanceof TruffleString.IllegalByteArrayLengthException) {
            return new RaiseException(TranslateExceptionNode.getContext(node), TranslateExceptionNode.coreExceptions(node).argumentError(e.getMessage(), node));
        }
        if (e instanceof UnsupportedSpecializationException) {
            UnsupportedSpecializationException unsupported = (UnsupportedSpecializationException)e;
            return new RaiseException(TranslateExceptionNode.getContext(node), TranslateExceptionNode.translateUnsupportedSpecialization(unsupported.getNode(), TranslateExceptionNode.getContext(node), unsupported));
        }
        if (e instanceof StackOverflowError) {
            StackOverflowError stackOverflowError = (StackOverflowError)e;
            return new RaiseException(TranslateExceptionNode.getContext(node), TranslateExceptionNode.translateStackOverflow(node, TranslateExceptionNode.getContext(node), stackOverflowError));
        }
        return new RaiseException(TranslateExceptionNode.getContext(node), TranslateExceptionNode.translateOutOfMemory(node, TranslateExceptionNode.getContext(node), (OutOfMemoryError)e));
    }

    @CompilerDirectives.TruffleBoundary
    private static RubyException translateStackOverflow(Node node, RubyContext context, StackOverflowError error) {
        boolean ignore = VMPrimitiveNodes.InitStackOverflowClassesEagerlyNode.ignore(error);
        if (!ignore) {
            if (context.getOptions().EXCEPTIONS_WARN_STACKOVERFLOW) {
                System.err.print("[ruby] WARNING StackOverflowError\n");
            }
            TranslateExceptionNode.logJavaException(context, node, error);
        }
        return context.getCoreExceptions().systemStackErrorStackLevelTooDeep(node, error, !ignore);
    }

    @CompilerDirectives.TruffleBoundary
    private static RubyException translateOutOfMemory(Node node, RubyContext context, OutOfMemoryError error) {
        if (context.getOptions().EXCEPTIONS_WARN_OUT_OF_MEMORY) {
            System.err.print("[ruby] WARNING OutOfMemoryError\n");
        }
        TranslateExceptionNode.logJavaException(context, node, error);
        return context.getCoreExceptions().noMemoryError(node, error);
    }

    @CompilerDirectives.TruffleBoundary
    private static RubyException translateUnsupportedSpecialization(Node node, RubyContext context, UnsupportedSpecializationException exception) {
        TranslateExceptionNode.logJavaException(context, node, (Throwable)exception);
        StringBuilder builder = new StringBuilder();
        builder.append("TruffleRuby doesn't have a case for the ");
        builder.append(exception.getNode().getClass().getName());
        builder.append(" node with values of type");
        TranslateExceptionNode.argumentsToString(builder, exception.getSuppliedValues());
        builder.append('\n');
        BacktraceFormatter.appendJavaStackTrace((Throwable)exception, builder);
        String message = builder.toString().strip();
        return context.getCoreExceptions().typeError(message, node, (Throwable)exception);
    }

    public static StringBuilder argumentsToString(StringBuilder builder, Object[] arguments) {
        for (Object value : arguments) {
            builder.append(" ");
            if (value == null) {
                builder.append("null");
            } else if (value instanceof RubyDynamicObject) {
                RubyDynamicObject dynamicObject = (RubyDynamicObject)((Object)value);
                builder.append(dynamicObject.getLogicalClass().fields.getName());
                builder.append("(");
                builder.append(value.getClass().getName());
                builder.append(")");
                if (value instanceof RubyArray) {
                    RubyArray array = (RubyArray)value;
                    builder.append("[");
                    if (array.getStore() == null) {
                        builder.append("null");
                    } else {
                        builder.append(array.getStore().getClass().getName());
                    }
                    builder.append(",");
                    builder.append(array.size);
                    builder.append("]");
                } else if (RubyGuards.isRubyHash(value)) {
                    Object store = ((RubyHash)value).store;
                    builder.append("[");
                    builder.append(store.getClass().getName());
                    builder.append("]");
                }
            } else {
                builder.append(value.getClass().getName());
            }
            if (!(value instanceof Number) && !(value instanceof Boolean)) continue;
            builder.append("=");
            builder.append(value.toString());
        }
        return builder;
    }

    @CompilerDirectives.TruffleBoundary
    private static void printStackTrace(Throwable exception) {
        exception.printStackTrace();
    }
}

