/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;

public final class SymbolProcNode
extends RubyContextSourceNode {
    private final String symbol;
    @Node.Child
    private DispatchNode callNode;

    public SymbolProcNode(String symbol) {
        this.symbol = symbol;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        assert (RubyArguments.getRawArgumentsCount((Frame)frame) >= 1) : "guaranteed from arity check";
        Object receiver = RubyArguments.getArgument((Frame)frame, 0);
        return this.getCallNode().execute((Frame)frame, receiver, this.symbol, RubyArguments.repack(frame.getArguments(), receiver, 1), DispatchConfiguration.PUBLIC);
    }

    private DispatchNode getCallNode() {
        if (this.callNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callNode = (DispatchNode)this.insert(DispatchNode.create());
        }
        return this.callNode;
    }

    @Override
    public RubyNode cloneUninitialized() {
        SymbolProcNode copy = new SymbolProcNode(this.symbol);
        return copy.copyFlags(this);
    }
}

