/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.annotations.Split;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.cast.NameToJavaStringNode;
import org.truffleruby.core.cast.ToSymbolNode;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.method.RubyMethod;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.LookupMethodOnSelfNode;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.LogicalClassNode;
import org.truffleruby.language.objects.MetaClassNode;

@GenerateUncached
public abstract class GetMethodObjectNode
extends RubyBaseNode {
    public abstract RubyMethod execute(Frame var1, Object var2, Object var3, DispatchConfiguration var4);

    @Specialization
    RubyMethod getMethodObject(Frame frame, Object self, Object name, DispatchConfiguration dispatchConfig, @Cached NameToJavaStringNode nameToJavaStringNode, @Cached LookupMethodOnSelfNode lookupMethodNode, @Cached ToSymbolNode toSymbolNode, @Cached DispatchNode respondToMissingNode, @Cached BooleanCastNode booleanCastNode, @Cached InlinedConditionProfile notFoundProfile, @Cached InlinedConditionProfile respondToMissingProfile, @Cached LogicalClassNode logicalClassNode) {
        String normalizedName = nameToJavaStringNode.execute(this, name);
        InternalMethod method = lookupMethodNode.execute(frame, self, normalizedName, dispatchConfig);
        if (notFoundProfile.profile((Node)this, method == null)) {
            RubySymbol symbolName = toSymbolNode.execute(this, name);
            Object respondToMissing = respondToMissingNode.call(self, "respond_to_missing?", symbolName, (Object)dispatchConfig.ignoreVisibility);
            if (respondToMissingProfile.profile((Node)this, booleanCastNode.execute(this, respondToMissing))) {
                InternalMethod methodMissing = lookupMethodNode.execute(frame, self, "method_missing", DispatchConfiguration.PRIVATE_RETURN_MISSING_IGNORE_REFINEMENTS);
                method = this.createMissingMethod(self, symbolName, normalizedName, methodMissing);
            } else {
                throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().nameErrorUndefinedMethod(normalizedName, logicalClassNode.execute(self), this));
            }
        }
        RubyMethod instance = new RubyMethod(this.coreLibrary().methodClass, this.getLanguage().methodShape, self, method);
        AllocationTracing.trace(instance, this);
        return instance;
    }

    @CompilerDirectives.TruffleBoundary
    private InternalMethod createMissingMethod(Object self, RubySymbol name, String normalizedName, InternalMethod methodMissing) {
        SharedMethodInfo info = methodMissing.getSharedMethodInfo().convertMethodMissingToMethod(methodMissing.getDeclaringModule(), normalizedName);
        CallMethodMissingWithStaticName newBody = new CallMethodMissingWithStaticName(name);
        RubyRootNode newRootNode = new RubyRootNode(this.getLanguage(), info.getSourceSection(), new FrameDescriptor((Object)nil), info, newBody, Split.HEURISTIC, ReturnID.INVALID);
        RootCallTarget newCallTarget = newRootNode.getCallTarget();
        RubyClass module = MetaClassNode.executeUncached(self);
        return new InternalMethod(this.getContext(), info, methodMissing.getLexicalScope(), DeclarationContext.NONE, normalizedName, module, Visibility.PUBLIC, newCallTarget);
    }

    private static final class CallMethodMissingWithStaticName
    extends RubyContextSourceNode {
        private final RubySymbol methodName;
        @Node.Child
        private DispatchNode methodMissing = DispatchNode.create();

        public CallMethodMissingWithStaticName(RubySymbol methodName) {
            this.methodName = methodName;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object[] originalUserArguments = RubyArguments.getRawArguments((Frame)frame);
            Object[] newUserArguments = ArrayUtils.unshift(originalUserArguments, this.methodName);
            return this.methodMissing.callWithDescriptor(RubyArguments.getSelf((Frame)frame), "method_missing", RubyArguments.getBlock((Frame)frame), RubyArguments.getDescriptor((Frame)frame), newUserArguments);
        }

        @Override
        public RubyNode cloneUninitialized() {
            CallMethodMissingWithStaticName copy = new CallMethodMissingWithStaticName(this.methodName);
            return copy.copyFlags(this);
        }
    }
}

