/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.methods;

import com.oracle.truffle.api.CompilerAsserts;
import java.util.ArrayList;
import java.util.Arrays;
import org.truffleruby.core.proc.ProcType;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.parser.ArgumentDescriptor;
import org.truffleruby.parser.ArgumentType;

public final class Arity {
    public static final String[] NO_KEYWORDS = StringUtils.EMPTY_STRING_ARRAY;
    public static final Arity NO_ARGUMENTS = new Arity(0, 0, false);
    public static final Arity ONE_REQUIRED = new Arity(1, 0, false);
    public static final Arity ANY_ARGUMENTS = new Arity(0, 0, true);
    private final int preRequired;
    private final int optional;
    private final boolean hasRest;
    private final boolean isImplicitRest;
    private final int postRequired;
    private final boolean hasKeywordsRest;
    private final String[] keywordArguments;
    private final int requiredKeywordArgumentsCount;
    private final int arityNumber;
    private final int procArityNumber;

    public Arity(int preRequired, int optional, boolean hasRest) {
        this(preRequired, optional, hasRest, false, 0, NO_KEYWORDS, 0, false);
    }

    public Arity(int preRequired, int optional, boolean hasRest, boolean isImplicitRest, int postRequired, String[] keywordArguments, int requiredKeywordArgumentsCount, boolean hasKeywordsRest) {
        this.preRequired = preRequired;
        this.optional = optional;
        this.hasRest = hasRest;
        this.isImplicitRest = isImplicitRest;
        this.postRequired = postRequired;
        this.keywordArguments = keywordArguments;
        this.requiredKeywordArgumentsCount = requiredKeywordArgumentsCount;
        this.hasKeywordsRest = hasKeywordsRest;
        this.arityNumber = this.computeArityNumber(false);
        this.procArityNumber = this.computeArityNumber(true);
        assert (keywordArguments != null && preRequired >= 0 && optional >= 0 && postRequired >= 0) : this.toString();
    }

    public Arity consumingFirstRequired() {
        return new Arity(Integer.max(this.preRequired - 1, 0), this.optional, this.hasRest, this.isImplicitRest, this.postRequired, this.keywordArguments, this.requiredKeywordArgumentsCount, this.hasKeywordsRest);
    }

    public boolean checkPositionalArguments(int given) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        int required = this.getRequired();
        return given >= required && (this.hasRest && !this.isImplicitRest || given <= required + this.optional);
    }

    public int getPreRequired() {
        return this.preRequired;
    }

    public int getRequired() {
        return this.preRequired + this.postRequired;
    }

    public int getOptional() {
        return this.optional;
    }

    public boolean hasRest() {
        return this.hasRest;
    }

    public boolean isImplicitRest() {
        return this.isImplicitRest;
    }

    public boolean acceptsKeywords() {
        return this.hasKeywords() || this.hasKeywordsRest();
    }

    public boolean hasKeywords() {
        return this.keywordArguments.length != 0;
    }

    public boolean hasKeywordsRest() {
        return this.hasKeywordsRest;
    }

    public boolean allKeywordsOptional() {
        return this.requiredKeywordArgumentsCount == 0;
    }

    private int computeArityNumber(boolean isProc) {
        int count = this.getRequired();
        if (this.acceptsKeywords() && !this.allKeywordsOptional()) {
            ++count;
        }
        if (this.hasRest && !this.isImplicitRest || !isProc && (this.optional > 0 || this.acceptsKeywords() && this.allKeywordsOptional())) {
            count = -count - 1;
        }
        return count;
    }

    public int getProcArityNumber(ProcType type) {
        return type == ProcType.PROC ? this.procArityNumber : this.arityNumber;
    }

    public int getMethodArityNumber() {
        return this.arityNumber;
    }

    public String[] getKeywordArguments() {
        return this.keywordArguments;
    }

    public String[] getRequiredKeywordArguments() {
        String[] requiredKeywords = new String[this.requiredKeywordArgumentsCount];
        for (int i = 0; i < requiredKeywords.length; ++i) {
            requiredKeywords[i] = this.keywordArguments[i];
        }
        return requiredKeywords;
    }

    public ArgumentDescriptor[] toUnnamedArgumentDescriptors() {
        int i;
        ArrayList<ArgumentDescriptor> descs = new ArrayList<ArgumentDescriptor>();
        for (i = 0; i < this.preRequired; ++i) {
            descs.add(new ArgumentDescriptor(ArgumentType.unnamedreq));
        }
        for (i = 0; i < this.optional; ++i) {
            descs.add(new ArgumentDescriptor(ArgumentType.unnamedopt));
        }
        if (this.hasRest) {
            descs.add(new ArgumentDescriptor(ArgumentType.unnamedrest));
        }
        for (i = 0; i < this.postRequired; ++i) {
            descs.add(new ArgumentDescriptor(ArgumentType.unnamedreq));
        }
        for (String keyword : this.keywordArguments) {
            descs.add(new ArgumentDescriptor(ArgumentType.key, keyword));
        }
        if (this.hasKeywordsRest) {
            descs.add(new ArgumentDescriptor(ArgumentType.unnamedkeyrest));
        }
        return descs.toArray(ArgumentDescriptor.EMPTY_ARRAY);
    }

    public String toString() {
        return "Arity{preRequired = " + this.preRequired + ", optional = " + this.optional + ", hasRest = " + this.hasRest + ", isImplicitRest = " + this.isImplicitRest + ", postRequired = " + this.postRequired + ", keywordArguments = " + Arrays.toString(this.keywordArguments) + ", requiredKeywordArgumentsCount = " + this.requiredKeywordArgumentsCount + ", hasKeywordsRest = " + this.hasKeywordsRest + "}";
    }
}

