/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.locals;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.locals.FlipFlopNodeGen;

public abstract class FlipFlopNode
extends RubyContextSourceNode {
    @Node.Child
    private RubyNode begin;
    @Node.Child
    private RubyNode end;
    private final boolean exclusive;
    private final int frameLevel;
    private final int frameSlot;

    public FlipFlopNode(RubyNode begin, RubyNode end, boolean exclusive, int frameLevel, int frameSlot) {
        this.begin = begin;
        this.end = end;
        this.exclusive = exclusive;
        this.frameLevel = frameLevel;
        this.frameSlot = frameSlot;
    }

    @Specialization
    Object doFlipFlop(VirtualFrame frame, @Cached BooleanCastNode beginCast, @Cached BooleanCastNode endCast) {
        if (this.exclusive) {
            if (this.getState(frame)) {
                if (endCast.execute(this, this.end.execute(frame))) {
                    this.setState(frame, false);
                }
                return true;
            }
            boolean newState = beginCast.execute(this, this.begin.execute(frame));
            this.setState(frame, newState);
            return newState;
        }
        if (this.getState(frame)) {
            if (endCast.execute(this, this.end.execute(frame))) {
                this.setState(frame, false);
            }
            return true;
        }
        if (beginCast.execute(this, this.begin.execute(frame))) {
            this.setState(frame, !endCast.execute(this, this.end.execute(frame)));
            return true;
        }
        return false;
    }

    private boolean getState(VirtualFrame frame) {
        Frame declarationFrame = RubyArguments.getDeclarationFrame((Frame)frame, this.frameLevel);
        return declarationFrame.getBoolean(this.frameSlot);
    }

    private void setState(VirtualFrame frame, boolean state) {
        Frame declarationFrame = RubyArguments.getDeclarationFrame((Frame)frame, this.frameLevel);
        declarationFrame.setBoolean(this.frameSlot, state);
    }

    @Override
    public RubyNode cloneUninitialized() {
        FlipFlopNode copy = FlipFlopNodeGen.create(this.begin.cloneUninitialized(), this.end.cloneUninitialized(), this.exclusive, this.frameLevel, this.frameSlot);
        return copy.copyFlags(this);
    }
}

