/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.loader;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.truffleruby.RubyContext;
import org.truffleruby.core.mutex.MutexOperations;

public final class ReentrantLockFreeingMap<K> {
    private final ConcurrentHashMap<K, ReentrantLock> locks = new ConcurrentHashMap();

    @CompilerDirectives.TruffleBoundary
    public ReentrantLock get(K key) {
        ReentrantLock newLock;
        ReentrantLock wasLock;
        ReentrantLock currentLock = this.locks.get(key);
        ReentrantLock lock = currentLock == null ? ((wasLock = this.locks.putIfAbsent(key, newLock = new ReentrantLock())) == null ? newLock : wasLock) : currentLock;
        return lock;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isCurrentThreadHoldingLock(K key) {
        ReentrantLock lock = this.locks.get(key);
        return lock != null && lock.isHeldByCurrentThread();
    }

    @CompilerDirectives.TruffleBoundary
    public boolean lock(RubyContext context, K key, ReentrantLock lock, Node currentNode) {
        MutexOperations.lockInternal(context, lock, currentNode);
        if (lock == this.locks.get(key)) {
            return true;
        }
        lock.unlock();
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public void unlock(K key, ReentrantLock lock) {
        if (!lock.hasQueuedThreads()) {
            this.locks.remove(key);
        }
        lock.unlock();
    }
}

