/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.loader;

import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.collections.ByteArrayBuilder;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.language.control.RaiseException;

public final class EmbeddedScript {
    private final RubyContext context;
    private static final byte[] PREFIX_COMMENT = StringOperations.encodeAsciiBytes("# line ignored by Ruby: ");

    public EmbeddedScript(RubyContext context) {
        this.context = context;
    }

    public boolean shouldTransform(byte[] sourceBytes) {
        return this.isShebangLine(sourceBytes) || this.context.getOptions().IGNORE_LINES_BEFORE_RUBY_SHEBANG;
    }

    byte[] transformForExecution(Node currentNode, byte[] sourceBytes, String path) {
        boolean rubyShebangLine;
        ByteArrayBuilder transformed = new ByteArrayBuilder(sourceBytes.length * 2);
        int n = 0;
        do {
            int lineLength;
            if (n == sourceBytes.length) {
                throw new RaiseException(this.context, this.context.getCoreExceptions().loadError("no Ruby script found in input", path, currentNode));
            }
            int lineStart = n;
            while (n < sourceBytes.length && sourceBytes[n] != 10) {
                ++n;
            }
            if (n < sourceBytes.length && sourceBytes[n] == 10) {
                ++n;
            }
            if (!(rubyShebangLine = this.isRubyShebangLine(sourceBytes, lineStart, lineLength = n - lineStart))) {
                transformed.append(PREFIX_COMMENT);
            }
            transformed.append(sourceBytes, lineStart, lineLength);
        } while (!rubyShebangLine);
        transformed.append(sourceBytes, n, sourceBytes.length - n);
        return transformed.getBytes();
    }

    private boolean isShebangLine(byte[] bytes) {
        return this.isShebangLine(bytes, 0);
    }

    private boolean isRubyShebangLine(byte[] bytes, int lineStart, int lineLength) {
        return this.isShebangLine(bytes, lineStart) && EmbeddedScript.lineContainsRuby(bytes, lineStart, lineLength);
    }

    private boolean isShebangLine(byte[] bytes, int lineStart) {
        return bytes.length - lineStart >= 2 && bytes[lineStart] == 35 && bytes[lineStart + 1] == 33;
    }

    public static boolean lineContainsRuby(byte[] bytes, int lineStart, int lineLength) {
        if (lineLength < 4) {
            return false;
        }
        int limit = lineStart + lineLength - 3;
        for (int n = lineStart; n < limit; ++n) {
            if (bytes[n] != 114 || bytes[n + 1] != 117 || bytes[n + 2] != 98 || bytes[n + 3] != 121) continue;
            return true;
        }
        return false;
    }
}

