/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.library;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.language.RubyGuards;

public abstract class RubyStringLibrary {
    @NeverDefault
    public static RubyStringLibrary create() {
        return new Cached();
    }

    public static RubyStringLibrary getUncached() {
        CompilerAsserts.neverPartOfCompilation((String)"uncached libraries must not be used in PE code");
        return Uncached.INSTANCE;
    }

    public abstract boolean seen(Object var1);

    public abstract boolean isRubyString(Object var1);

    @NeverDefault
    public abstract AbstractTruffleString getTString(Object var1);

    @NeverDefault
    public abstract RubyEncoding getEncoding(Object var1);

    @NeverDefault
    public final TruffleString.Encoding getTEncoding(Object object) {
        return this.getEncoding((Object)object).tencoding;
    }

    public abstract int byteLength(Object var1);

    public abstract RubyEncoding profileEncoding(RubyEncoding var1);

    static final class Cached
    extends RubyStringLibrary {
        @CompilerDirectives.CompilationFinal
        private boolean seenMutable;
        @CompilerDirectives.CompilationFinal
        private boolean seenImmutable;
        @CompilerDirectives.CompilationFinal
        private boolean seenOther;
        @CompilerDirectives.CompilationFinal
        private Object cachedEncoding;
        private static final Object GENERIC = new Object();

        Cached() {
        }

        @Override
        public boolean seen(Object object) {
            assert (object instanceof RubyString || object instanceof ImmutableRubyString);
            if (this.seenMutable) {
                return object instanceof RubyString;
            }
            if (this.seenImmutable) {
                return object instanceof ImmutableRubyString;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getTString(object);
            return true;
        }

        @Override
        public boolean isRubyString(Object object) {
            if (this.seenMutable && object instanceof RubyString) {
                return true;
            }
            if (this.seenImmutable && object instanceof ImmutableRubyString) {
                return true;
            }
            if (this.seenOther && RubyGuards.isNotRubyString(object)) {
                return false;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.specializeIsRubyString(object);
        }

        private boolean specializeIsRubyString(Object object) {
            if (object instanceof RubyString) {
                this.seenMutable = true;
                return true;
            }
            if (object instanceof ImmutableRubyString) {
                this.seenImmutable = true;
                return true;
            }
            if (RubyGuards.isNotRubyString(object)) {
                this.seenOther = true;
                return false;
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public AbstractTruffleString getTString(Object object) {
            if (this.seenMutable && object instanceof RubyString) {
                return ((RubyString)((Object)object)).tstring;
            }
            if (this.seenImmutable && object instanceof ImmutableRubyString) {
                return ((ImmutableRubyString)object).tstring;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.specializeGetTString(object);
        }

        private AbstractTruffleString specializeGetTString(Object object) {
            if (object instanceof RubyString) {
                this.seenMutable = true;
                return ((RubyString)((Object)object)).tstring;
            }
            if (object instanceof ImmutableRubyString) {
                this.seenImmutable = true;
                return ((ImmutableRubyString)object).tstring;
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public RubyEncoding profileEncoding(RubyEncoding encoding) {
            Object localCachedEncoding = this.cachedEncoding;
            if (encoding == localCachedEncoding) {
                return (RubyEncoding)localCachedEncoding;
            }
            if (localCachedEncoding == GENERIC) {
                return encoding;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.specializeProfileEncoding(encoding);
        }

        private RubyEncoding specializeProfileEncoding(RubyEncoding encoding) {
            Object localCachedEncoding = this.cachedEncoding;
            if (localCachedEncoding == null) {
                this.cachedEncoding = encoding;
            } else if (encoding != localCachedEncoding) {
                this.cachedEncoding = GENERIC;
            }
            return encoding;
        }

        @Override
        public RubyEncoding getEncoding(Object object) {
            RubyEncoding encoding;
            if (this.seenMutable && object instanceof RubyString) {
                encoding = ((RubyString)((Object)object)).getEncodingUnprofiled();
            } else if (this.seenImmutable && object instanceof ImmutableRubyString) {
                encoding = ((ImmutableRubyString)object).getEncodingUnprofiled();
            } else {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.specializeGetEncoding(object);
            }
            return this.profileEncoding(encoding);
        }

        private RubyEncoding specializeGetEncoding(Object object) {
            RubyEncoding encoding;
            if (object instanceof RubyString) {
                this.seenMutable = true;
                encoding = ((RubyString)((Object)object)).getEncodingUnprofiled();
            } else if (object instanceof ImmutableRubyString) {
                this.seenImmutable = true;
                encoding = ((ImmutableRubyString)object).getEncodingUnprofiled();
            } else {
                throw CompilerDirectives.shouldNotReachHere();
            }
            return this.specializeProfileEncoding(encoding);
        }

        @Override
        public int byteLength(Object object) {
            if (this.seenMutable && object instanceof RubyString) {
                RubyString mutable = (RubyString)((Object)object);
                return this.getTString((Object)mutable).byteLength(this.getTEncoding((Object)mutable));
            }
            if (this.seenImmutable && object instanceof ImmutableRubyString) {
                ImmutableRubyString immutable = (ImmutableRubyString)object;
                return this.getTString(immutable).byteLength(this.getTEncoding(immutable));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.specializeByteLength(object);
        }

        private int specializeByteLength(Object object) {
            return this.getTString(object).byteLength(this.getTEncoding(object));
        }
    }

    static final class Uncached
    extends RubyStringLibrary {
        static final Uncached INSTANCE = new Uncached();

        Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean seen(Object object) {
            assert (object instanceof RubyString || object instanceof ImmutableRubyString);
            return true;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isRubyString(Object object) {
            return object instanceof RubyString || object instanceof ImmutableRubyString;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public AbstractTruffleString getTString(Object object) {
            if (object instanceof RubyString) {
                return ((RubyString)((Object)object)).tstring;
            }
            if (object instanceof ImmutableRubyString) {
                return ((ImmutableRubyString)object).tstring;
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public RubyEncoding profileEncoding(RubyEncoding encoding) {
            return encoding;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public RubyEncoding getEncoding(Object object) {
            if (object instanceof RubyString) {
                return ((RubyString)((Object)object)).getEncodingUncached();
            }
            if (object instanceof ImmutableRubyString) {
                return ((ImmutableRubyString)object).getEncodingUncached();
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int byteLength(Object object) {
            return this.getTString(object).byteLength(this.getTEncoding(object));
        }
    }
}

