/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.globals;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import org.truffleruby.RubyContext;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;

public final class GlobalVariableStorage {
    public static final Object UNSET_VALUE = NotProvided.INSTANCE;
    private final CyclicAssumption unchangedAssumption = new CyclicAssumption("global variable unchanged");
    private int changes = 0;
    @CompilerDirectives.CompilationFinal
    private volatile boolean assumeConstant = true;
    private volatile Object value;
    private final RubyProc getter;
    private final RubyProc setter;
    private final RubyProc isDefined;

    public GlobalVariableStorage(RubyProc getter, RubyProc setter, RubyProc isDefined) {
        this(UNSET_VALUE, getter, setter, isDefined);
    }

    GlobalVariableStorage(Object value, RubyProc getter, RubyProc setter, RubyProc isDefined) {
        assert (getter == null == (setter == null) && getter == null == (isDefined == null));
        assert (value != null);
        this.value = value;
        this.getter = getter;
        this.setter = setter;
        this.isDefined = isDefined;
    }

    @NeverDefault
    public Object getValue() {
        Object currentValue = this.value;
        return currentValue == UNSET_VALUE ? Nil.INSTANCE : currentValue;
    }

    @NeverDefault
    public Object getRawValue() {
        return this.value;
    }

    public boolean isDefined() {
        return this.value != UNSET_VALUE;
    }

    public boolean isSimple() {
        return !this.hasHooks();
    }

    public boolean hasHooks() {
        return this.getter != null;
    }

    public RubyProc getGetter() {
        return this.getter;
    }

    public RubyProc getSetter() {
        return this.setter;
    }

    public RubyProc getIsDefined() {
        return this.isDefined;
    }

    public Assumption getUnchangedAssumption() {
        return this.unchangedAssumption.getAssumption();
    }

    @Idempotent
    public boolean isAssumeConstant() {
        return this.assumeConstant;
    }

    public void setValueInternal(Object value) {
        assert (value != null);
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void updateAssumeConstant(RubyContext context) {
        GlobalVariableStorage globalVariableStorage = this;
        synchronized (globalVariableStorage) {
            if (!this.assumeConstant) {
                return;
            }
            if (this.changes <= context.getOptions().GLOBAL_VARIABLE_MAX_INVALIDATIONS) {
                ++this.changes;
                this.unchangedAssumption.invalidate();
            } else {
                this.assumeConstant = false;
                this.unchangedAssumption.getAssumption().invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void noLongerAssumeConstant() {
        GlobalVariableStorage globalVariableStorage = this;
        synchronized (globalVariableStorage) {
            this.assumeConstant = false;
            this.unchangedAssumption.getAssumption().invalidate();
        }
    }
}

