/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.truffleruby.core.exception.ExceptionOperations;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.fiber.FiberManager;
import org.truffleruby.core.kernel.AtExitManager;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.backtrace.BacktraceFormatter;
import org.truffleruby.language.control.ExitException;
import org.truffleruby.language.control.KillException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.objects.IsANode;
import org.truffleruby.shared.ProcessStatus;

public final class TopLevelRaiseHandler
extends RubyBaseNode {
    @CompilerDirectives.TruffleBoundary
    public int execute(Runnable body) {
        int exitCode = 0;
        AbstractTruffleException caughtException = null;
        try {
            body.run();
        }
        catch (ExitException e) {
            return ProcessStatus.exitCode((int)e.getCode());
        }
        catch (AbstractTruffleException e) {
            assert (!(e instanceof KillException)) : e;
            caughtException = e;
            exitCode = this.statusFromException(caughtException);
            this.getLanguage().getCurrentFiber().setLastException(ExceptionOperations.getExceptionObject(caughtException));
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            assert (!(e instanceof FiberManager.FiberShutdownException)) : e;
            BacktraceFormatter.printInternalError(this.getContext(), e, "an internal exception escaped out of the interpreter");
            return ProcessStatus.exitCode((int)1);
        }
        String step = "unexpected internal exception in at_exit";
        try {
            AbstractTruffleException atExitException = this.getContext().getAtExitManager().runAtExitHooks();
            if (atExitException != null) {
                exitCode = this.statusFromException(atExitException);
            }
            step = "an internal exception escaped out of the interpreter";
            if (caughtException != null) {
                int signo;
                if (!AtExitManager.isSilentException(this.getContext(), caughtException)) {
                    this.getContext().getDefaultBacktraceFormatter().printTopLevelRubyExceptionOnEnvStderr(caughtException);
                }
                if ((signo = this.handleSignalException(caughtException)) != 0) {
                    return ProcessStatus.signal((int)signo);
                }
            }
        }
        catch (ExitException e) {
            exitCode = e.getCode();
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            BacktraceFormatter.printInternalError(this.getContext(), e, step);
            return ProcessStatus.exitCode((int)1);
        }
        return ProcessStatus.exitCode((int)exitCode);
    }

    private int statusFromException(AbstractTruffleException exception) {
        InteropLibrary interopLibrary = InteropLibrary.getUncached((Object)((Object)exception));
        try {
            if (interopLibrary.getExceptionType((Object)exception) == ExceptionType.EXIT) {
                return interopLibrary.getExceptionExitStatus((Object)exception);
            }
            return 1;
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    private int handleSignalException(AbstractTruffleException exception) {
        if (exception instanceof RaiseException) {
            RubyException rubyException = ((RaiseException)exception).getException();
            if (IsANode.getUncached().executeIsA(rubyException, this.coreLibrary().signalExceptionClass)) {
                return (Integer)DispatchNode.getUncached().call(rubyException, "signo");
            }
        }
        return 0;
    }
}

