/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.exceptions;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.exceptions.RescueNode;

public final class RescueClassesNode
extends RescueNode {
    @Node.Children
    final RubyNode[] handlingClassNodes;

    public RescueClassesNode(RubyNode[] handlingClassNodes, RubyNode rescueBody, boolean canOmitBacktrace) {
        super(rescueBody, canOmitBacktrace);
        this.handlingClassNodes = handlingClassNodes;
    }

    @Override
    @ExplodeLoop
    public boolean canHandle(VirtualFrame frame, Object exceptionObject, BooleanCastNode booleanCastNode) {
        for (RubyNode handlingClassNode : this.handlingClassNodes) {
            Object handlingClass = handlingClassNode.execute(frame);
            if (!this.matches(exceptionObject, handlingClass, booleanCastNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        return RubyNode.defaultIsDefined(this);
    }

    @Override
    public RubyNode cloneUninitialized() {
        RescueClassesNode copy = new RescueClassesNode(RescueClassesNode.cloneUninitialized(this.handlingClassNodes), this.getRescueBody().cloneUninitialized(), this.canOmitBacktrace);
        return copy.copyFlags(this);
    }
}

