/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.dispatch;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.hash.HashNodes;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.KeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.KeywordArgumentsDescriptorManager;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;

public abstract class LiteralCallNode
extends RubyContextSourceNode {
    protected final ArgumentsDescriptor descriptor;
    @Node.Child
    private HashNodes.CopyHashAndSetRuby2KeywordsNode copyHashAndSetRuby2KeywordsNode;
    protected final boolean isSplatted;
    @CompilerDirectives.CompilationFinal
    private boolean lastArgIsNotHashProfile;
    @CompilerDirectives.CompilationFinal
    private boolean notRuby2KeywordsHashProfile;
    @CompilerDirectives.CompilationFinal
    private boolean emptyKeywordsProfile;
    @CompilerDirectives.CompilationFinal
    private boolean notEmptyKeywordsProfile;

    protected LiteralCallNode(boolean isSplatted, ArgumentsDescriptor descriptor) {
        this.isSplatted = isSplatted;
        this.descriptor = descriptor;
    }

    protected ArgumentsDescriptor getArgumentsDescriptorAndCheckRuby2KeywordsHash(Object[] args, int userArgsCount) {
        assert (this.isSplatted) : "this is only needed if isSplatted";
        if (this.descriptor == NoKeywordArgumentsDescriptor.INSTANCE && userArgsCount > 0) {
            Object lastArgument = ArrayUtils.getLast(args);
            assert (lastArgument != null);
            if (!(lastArgument instanceof RubyHash)) {
                if (!this.lastArgIsNotHashProfile) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.lastArgIsNotHashProfile = true;
                }
                return this.descriptor;
            }
            RubyHash hash = (RubyHash)lastArgument;
            if (hash.ruby2_keywords) {
                this.copyRuby2KeywordsHashBoundary(args, hash);
                return KeywordArgumentsDescriptorManager.EMPTY;
            }
            if (!this.notRuby2KeywordsHashProfile) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.notRuby2KeywordsHashProfile = true;
            }
        }
        return this.descriptor;
    }

    protected boolean emptyKeywordArguments(Object[] args) {
        assert (this.isSplatted || this.descriptor instanceof KeywordArgumentsDescriptor);
        if (((RubyHash)ArrayUtils.getLast(args)).empty()) {
            if (!this.emptyKeywordsProfile) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.emptyKeywordsProfile = true;
            }
            return true;
        }
        if (!this.notEmptyKeywordsProfile) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.notEmptyKeywordsProfile = true;
        }
        return false;
    }

    public static Object[] removeEmptyKeywordArguments(Object[] args) {
        return ArrayUtils.extractRange(args, 0, args.length - 1);
    }

    @HostCompilerDirectives.InliningCutoff
    private void copyRuby2KeywordsHashBoundary(Object[] args, RubyHash hash) {
        assert (ArrayUtils.getLast(args) == hash && hash.ruby2_keywords);
        if (this.copyHashAndSetRuby2KeywordsNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.copyHashAndSetRuby2KeywordsNode = (HashNodes.CopyHashAndSetRuby2KeywordsNode)this.insert(HashNodes.CopyHashAndSetRuby2KeywordsNode.create());
        }
        ArrayUtils.setLast(args, this.copyHashAndSetRuby2KeywordsNode.execute(hash, false));
    }
}

