/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.control;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.OrLazyValueDefinedNodeGen;
import org.truffleruby.utils.RunTwiceBranchProfile;

public abstract class OrLazyValueDefinedNode
extends RubyContextSourceNode {
    @Node.Child
    private RubyNode left;
    @Node.Child
    private RubyNode right;
    private final RunTwiceBranchProfile rightTwiceProfile = new RunTwiceBranchProfile();

    public OrLazyValueDefinedNode(RubyNode left, RubyNode right) {
        this.left = left;
        this.right = right;
    }

    @Specialization
    Object doOrLazyValueDefined(VirtualFrame frame, @Cached BooleanCastNode leftCast, @Cached InlinedCountingConditionProfile countingProfile) {
        Object leftValue = this.left.execute(frame);
        if (countingProfile.profile((Node)this, leftCast.execute(this, leftValue))) {
            return leftValue;
        }
        this.rightTwiceProfile.enter();
        return this.right.execute(frame);
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        return FrozenStrings.ASSIGNMENT;
    }

    @Override
    public RubyNode cloneUninitialized() {
        OrLazyValueDefinedNode copy = OrLazyValueDefinedNodeGen.create(this.left.cloneUninitialized(), this.right.cloneUninitialized());
        return copy.copyFlags(this);
    }
}

