/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.control;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.AndNodeGen;

public abstract class AndNode
extends RubyContextSourceNode {
    @Node.Child
    private RubyNode left;
    @Node.Child
    private RubyNode right;

    public AndNode(RubyNode left, RubyNode right) {
        this.left = left;
        this.right = right;
    }

    @Specialization
    Object doAnd(VirtualFrame frame, @Cached BooleanCastNode leftCast, @Cached InlinedCountingConditionProfile conditionProfile) {
        Object leftValue = this.left.execute(frame);
        if (conditionProfile.profile((Node)this, leftCast.execute(this, leftValue))) {
            return this.right.execute(frame);
        }
        return leftValue;
    }

    @Override
    public RubyNode cloneUninitialized() {
        AndNode copy = AndNodeGen.create(this.left.cloneUninitialized(), this.right.cloneUninitialized());
        return copy.copyFlags(this);
    }
}

