/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.constants;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyConstant;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.constants.OrAssignConstantNodeGen;
import org.truffleruby.language.constants.ReadConstantNode;
import org.truffleruby.language.constants.WriteConstantNode;
import org.truffleruby.utils.RunTwiceBranchProfile;

public abstract class OrAssignConstantNode
extends RubyContextSourceNode {
    @Node.Child
    protected ReadConstantNode readConstant;
    @Node.Child
    protected WriteConstantNode writeConstant;
    private final RunTwiceBranchProfile writeTwiceProfile = new RunTwiceBranchProfile();

    public OrAssignConstantNode(ReadConstantNode readConstant, WriteConstantNode writeConstant) {
        this.readConstant = readConstant;
        this.writeConstant = writeConstant;
    }

    @Specialization
    Object doOrAssignConstant(VirtualFrame frame, @Cached BooleanCastNode booleanCastNode, @Cached InlinedConditionProfile defined, @Cached InlinedConditionProfile triviallyUndefined) {
        Object value;
        if (triviallyUndefined.profile((Node)this, this.readConstant.isModuleTriviallyUndefined(frame, this.getLanguage(), this.getContext()))) {
            this.writeTwiceProfile.enter();
            return this.writeConstant.execute(frame);
        }
        RubyModule module = this.readConstant.evaluateModule(frame);
        RubyConstant constant = this.readConstant.getConstantIfDefined(module);
        boolean isDefined = defined.profile((Node)this, constant != null);
        Object object = value = isDefined ? this.readConstant.getConstant(module, constant) : null;
        if (!isDefined || !booleanCastNode.execute(this, value)) {
            this.writeTwiceProfile.enter();
            return this.writeConstant.execute(frame, module);
        }
        return value;
    }

    @Override
    public RubyNode cloneUninitialized() {
        OrAssignConstantNode copy = OrAssignConstantNodeGen.create((ReadConstantNode)this.readConstant.cloneUninitialized(), (WriteConstantNode)this.writeConstant.cloneUninitialized());
        return copy.copyFlags(this);
    }
}

