/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.constants;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.core.module.ConstantLookupResult;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyConstant;
import org.truffleruby.language.constants.LookupConstantBaseNode;
import org.truffleruby.language.constants.LookupConstantInterface;

public abstract class LookupConstantWithLexicalScopeNode
extends LookupConstantBaseNode
implements LookupConstantInterface {
    private final LexicalScope lexicalScope;
    private final String name;

    public LookupConstantWithLexicalScopeNode(LexicalScope lexicalScope, String name) {
        this.lexicalScope = lexicalScope;
        this.name = name;
    }

    public RubyModule getModule() {
        return this.lexicalScope.getLiveModule();
    }

    public abstract RubyConstant executeLookupConstant();

    @Override
    @SuppressFBWarnings(value={"ES"})
    public RubyConstant lookupConstant(Node node, LexicalScope lexicalScope, RubyModule module, String name, boolean checkName) {
        assert (name == this.name);
        return this.executeLookupConstant();
    }

    @Specialization(assumptions={"constant.getAssumptions()"})
    RubyConstant lookupConstant(@Cached(value="doLookup()") ConstantLookupResult constant) {
        if (constant.isDeprecated()) {
            this.warnDeprecatedConstant(this.getModule(), this.name);
        }
        return constant.getConstant();
    }

    @Specialization
    RubyConstant lookupConstantUncached(@Cached InlinedConditionProfile isDeprecatedProfile) {
        ConstantLookupResult constant = this.doLookup();
        if (isDeprecatedProfile.profile((Node)this, constant.isDeprecated())) {
            this.warnDeprecatedConstant(this.getModule(), this.name);
        }
        return constant.getConstant();
    }

    @CompilerDirectives.TruffleBoundary
    @NeverDefault
    protected ConstantLookupResult doLookup() {
        return ModuleOperations.lookupConstantWithLexicalScope(this.getContext(), this.lexicalScope, this.name);
    }
}

